package test.org.seasar.framework.sel.boolexps;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.boolexps.NotEqualExp;
import org.seasar.framework.sel.exps.NullExp;
import org.seasar.framework.sel.exps.ObjectExp;

public class NotEqualExpTest extends TestCase {

	public NotEqualExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		String s = "1234567890";
		String s2 = "1234567891";
		Integer i = new Integer(s);
		Integer i2 = new Integer(s2);
		ObjectExp iExp = new ObjectExp(i);
		ObjectExp i2Exp = new ObjectExp(i2);
		NotEqualExp neExp = new NotEqualExp(iExp, iExp);
		assertEquals("1", false, neExp.evaluate(null));

		NotEqualExp ne2Exp = new NotEqualExp(i2Exp, iExp);
		assertEquals("2", true, ne2Exp.evaluate(null));

		NotEqualExp ge3Exp = new NotEqualExp(iExp, i2Exp);
		assertEquals("3", true, ge3Exp.evaluate(null));

		NotEqualExp ne4Exp = new NotEqualExp(iExp, NullExp.NULL);
		assertEquals("4", true, ne4Exp.evaluate(null));

		NotEqualExp ne5Exp = new NotEqualExp(NullExp.NULL, iExp);
		assertEquals("5", true, ne5Exp.evaluate(null));

		NotEqualExp ne6Exp = new NotEqualExp(NullExp.NULL, NullExp.NULL);
		assertEquals("6", false, ne6Exp.evaluate(null));

	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(NotEqualExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { NotEqualExpTest.class.getName()});
	}
}