package test.org.seasar.framework.container.impl;

import junit.framework.TestCase;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.TooManyRegistrationRuntimeException;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;

/**
 * @author higa
 *
 */
public class S2ContainerImplTest extends TestCase {

	/**
	 * Constructor for InvocationImplTest.
	 * @param arg0
	 */
	public S2ContainerImplTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(S2ContainerImplTest.class);
	}
	
	public void testRegister() throws Exception {
		S2Container container = new S2ContainerImpl();
		container.register(A.class);
		container.register(B.class);
		container.register(B2.class);
		try {
			container.getComponent(A.class);
			fail("1");
		} catch (TooManyRegistrationRuntimeException ex) {
			System.out.println(ex);
			assertEquals("2", Hoge.class, ex.getKey());
			assertEquals("3", 2, ex.getComponentClasses().length);
			assertEquals("4", B.class, ex.getComponentClasses()[0]);
			assertEquals("5", B2.class, ex.getComponentClasses()[1]);
		}
	}
	
	public void testRegisterForAlreadRegistration() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDef cd = new ComponentDefImpl(B.class, "B");
		ComponentDef cd2 = new ComponentDefImpl(B2.class, "B");
		container.register(cd);
		container.register(cd2);
		try {
			container.getComponent("B");
			fail("1");
		} catch (TooManyRegistrationRuntimeException ex) {
			System.out.println(ex);
			assertEquals("2", "B", ex.getKey());
			assertEquals("3", 2, ex.getComponentClasses().length);
			assertEquals("4", B.class, ex.getComponentClasses()[0]);
			assertEquals("5", B2.class, ex.getComponentClasses()[1]);
		}
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	public static class A {
		
		private Hoge hoge_;
		
		public A(Hoge hoge) {
			hoge_ = hoge;
		}
		
		public String getHogeName() {
			return hoge_.getName();
		}
	}
	
	public interface Hoge {
		
		public String getName();
	}
	
	public static class B implements Hoge {
		
		public String getName() {
			return "B";
		}
	}
	
	public static class B2 implements Hoge {
		
		public String getName() {
			return "B2";
		}
	}
}