package test.org.seasar.framework;

import junit.framework.Test;
import junit.framework.TestSuite;
import test.org.seasar.framework.aop.impl.AopImplAllTests;
import test.org.seasar.framework.aop.proxy.AopProxyAllTests;
import test.org.seasar.framework.beans.factory.BeansFactoryAllTests;
import test.org.seasar.framework.beans.impl.BeansImplAllTests;
import test.org.seasar.framework.collection.CollectionAllTests;
import test.org.seasar.framework.container.impl.ContainerImplAllTests;
import test.org.seasar.framework.exception.ExceptionAllTests;
import test.org.seasar.framework.io.IOAllTests;
import test.org.seasar.framework.math.MathAllTests;
import test.org.seasar.framework.message.MessageAllTests;
import test.org.seasar.framework.reflect.ReflectAllTests;
import test.org.seasar.framework.regex.RegexAllTests;
import test.org.seasar.framework.sel.boolexps.SelBoolExpsAllTests;
import test.org.seasar.framework.sel.exps.SelExpsAllTests;
import test.org.seasar.framework.sel.parser.SelParserAllTests;
import test.org.seasar.framework.sel.tokenizer.SelTokenizerAllTests;
import test.org.seasar.framework.sel.util.SelUtilAllTests;
import test.org.seasar.framework.string.StringAllTests;

/**
 * @author higa
 *
 */
public class FrameworkAllTests {

	public static void main(String[] args) {
		junit.textui.TestRunner.run(FrameworkAllTests.class);
	}

	public static Test suite() {
		TestSuite suite = new TestSuite("Test for test.org.seasar.framework");
		//$JUnit-BEGIN$
		suite.addTest(AopImplAllTests.suite());
		suite.addTest(AopProxyAllTests.suite());
		suite.addTest(BeansFactoryAllTests.suite());
		suite.addTest(BeansImplAllTests.suite());
		suite.addTest(CollectionAllTests.suite());
		suite.addTest(ContainerImplAllTests.suite());
		suite.addTest(ExceptionAllTests.suite());
		suite.addTest(IOAllTests.suite());
		suite.addTest(MathAllTests.suite());
		suite.addTest(MessageAllTests.suite());
		suite.addTest(ReflectAllTests.suite());
		suite.addTest(RegexAllTests.suite());
		suite.addTest(SelBoolExpsAllTests.suite());
		suite.addTest(SelUtilAllTests.suite());
		suite.addTest(SelExpsAllTests.suite());
		suite.addTest(SelParserAllTests.suite());
		suite.addTest(SelTokenizerAllTests.suite());
		suite.addTest(StringAllTests.suite());
		//$JUnit-END$
		return suite;
	}
}
