package org.seasar.framework.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import org.seasar.framework.exception.lang.IllegalAccessRuntimeException;
import org.seasar.framework.exception.lang.InstantiationRuntimeException;
import org.seasar.framework.exception.lang.reflect.InvocationTargetRuntimeException;

/**
 * @author higa
 *
 */
public final class ConstructorUtil {
 
	/**
	 * 
	 */
	private ConstructorUtil() {
	}

	public static Object newInstance(Constructor constructor, Object[] args)
		throws
			InstantiationRuntimeException,
			IllegalAccessRuntimeException,
			InvocationTargetRuntimeException {

		try {
			return constructor.newInstance(args);
		} catch (InstantiationException ex) {
			throw new InstantiationRuntimeException(
				constructor.getDeclaringClass().getName(), ex);
		} catch (IllegalAccessException ex) {
			throw new IllegalAccessRuntimeException(
				constructor.getDeclaringClass().getName(), ex);
		} catch (InvocationTargetException ex) {
			throw new InvocationTargetRuntimeException(
				constructor.getDeclaringClass().getName(), ex);
		}
	}
}
