package org.seasar.framework.reflect;

import java.util.HashMap;
import java.util.Map;

import org.seasar.framework.exception.lang.ClassNotFoundRuntimeException;
import org.seasar.framework.exception.lang.IllegalAccessRuntimeException;
import org.seasar.framework.exception.lang.InstantiationRuntimeException;

/**
 * @author higa
 *
 */
public final class ClassUtil {

	private static Map wrapperToPrimitiveMap_ = new HashMap();

	static {
		wrapperToPrimitiveMap_.put(Character.class, Character.TYPE);
		wrapperToPrimitiveMap_.put(Short.class, Short.TYPE);
		wrapperToPrimitiveMap_.put(Integer.class, Integer.TYPE);
		wrapperToPrimitiveMap_.put(Long.class, Long.TYPE);
		wrapperToPrimitiveMap_.put(Double.class, Double.TYPE);
		wrapperToPrimitiveMap_.put(Float.class, Float.TYPE);
		wrapperToPrimitiveMap_.put(Boolean.class, Boolean.TYPE);
	}

	/**
	 * 
	 */
	private ClassUtil() {
	}

	public static Class forName(String className)
		throws ClassNotFoundRuntimeException {

		try {
			return Class.forName(className);
		} catch (ClassNotFoundException ex) {
			throw new ClassNotFoundRuntimeException(ex);
		}
	}

	public static Object newInstance(Class clazz)
		throws InstantiationRuntimeException, IllegalAccessRuntimeException {

		try {
			return clazz.newInstance();
		} catch (InstantiationException ex) {
			throw new InstantiationRuntimeException(clazz.getName(), ex);
		} catch (IllegalAccessException ex) {
			throw new IllegalAccessRuntimeException(clazz.getName(), ex);
		}
	}

	public static boolean isAssignableFrom(Class toClass, Class fromClass) {
		if (toClass == Object.class && !fromClass.isPrimitive()) {
			return true;
		}
		if (toClass.isPrimitive()) {
			fromClass = getPrimitiveClassIfWrapper(fromClass);
		}
		return toClass.isAssignableFrom(fromClass);
	}

	public static Class getPrimitiveClass(Class clazz) {
		return (Class) wrapperToPrimitiveMap_.get(clazz);
	}

	public static Class getPrimitiveClassIfWrapper(Class clazz) {
		Class ret = getPrimitiveClass(clazz);
		if (ret != null) {
			return ret;
		} else {
			return clazz;
		}
	}
}
