package org.seasar.framework.container.impl;

import java.util.HashSet;
import java.util.Set;

import org.seasar.framework.collection.ArrayMap;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.sel.SelContext;

/**
 * @author higa
 *
 */
public class S2ContainerImpl implements S2Container {

	private ArrayMap componentDefs_ = new ArrayMap();
	private SelContext selContext_ = new S2ContainerSelContext(this);

	public S2ContainerImpl() {
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponent(java.lang.Class)
	 */
	public Object getComponent(Class componentClass) {
		return getComponent0(componentClass);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponent(java.lang.String)
	 */
	public Object getComponent(String name) {
		return getComponent0(name);
	}

	private Object getComponent0(Object key) {
		ComponentDef cd = (ComponentDef) componentDefs_.get(key);
		if (cd == null) {
			throw new ComponentNotFoundRuntimeException(key);
		}
		return cd.getComponent();
	}

	/**
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Class)
	 */
	public void register(Class componentClass) {
		register(new ComponentDefImpl(componentClass));
	}
	
	/**
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Class, java.lang.String)
	 */
	public void register(Class componentClass, String componentName) {
		register(new ComponentDefImpl(componentClass, componentName));
	}

	/**
	 * @see org.seasar.framework.container.S2Container#register(org.seasar.framework.container.ComponentDef)
	 */
	public void register(ComponentDef componentDef) {
		componentDef.setContainer(this);
		Class[] classes =
			getAssignableClasses(componentDef.getComponentClass());
		for (int i = 0; i < classes.length; ++i) {
			if (componentDefs_.containsKey(classes[i])) {
				processTooManyRegistration(classes[i], componentDef);
			} else {
				componentDefs_.put(classes[i], componentDef);
			}
		}
		String componentName = componentDef.getComponentName();
		if (componentName != null) {
			if (componentDefs_.containsKey(componentName)) {
				processTooManyRegistration(componentName, componentDef);
			} else {
				componentDefs_.put(componentName, componentDef);
			}
		}
	}
	
	/**
	 * @see org.seasar.framework.container.S2Container#getSelContext()
	 */
	public SelContext getSelContext() {
		return selContext_;
	}

	private static Class[] getAssignableClasses(Class componentClass) {
		Set classes = new HashSet();
		for (Class clazz = componentClass;
			clazz != Object.class;
			clazz = clazz.getSuperclass()) {
			classes.add(clazz);
			Class[] interfaces = clazz.getInterfaces();
			for (int i = 0; i < interfaces.length; ++i) {
				classes.add(interfaces[i]);
			}
		}
		return (Class[]) classes.toArray(new Class[classes.size()]);
	}

	private void processTooManyRegistration(
		Object key,
		ComponentDef componentDef) {

		ComponentDef cd = (ComponentDef) componentDefs_.get(key);
		if (cd instanceof TooManyRegistrationComponentDef) {
			((TooManyRegistrationComponentDef) cd).addComponentClass(
				componentDef.getComponentClass());
		} else {
			TooManyRegistrationComponentDef tmrcf =
				new TooManyRegistrationComponentDef(key);
			tmrcf.addComponentClass(cd.getComponentClass());
			tmrcf.addComponentClass(componentDef.getComponentClass());
			componentDefs_.put(key, tmrcf);
		}
	}
}
