package org.seasar.framework.container.impl;

import java.util.ArrayList;
import java.util.List;

import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.MethodDef;
import org.seasar.framework.container.S2Container;

/**
 * @author higa
 *
 */
public class MethodDefImpl implements MethodDef {

	private String methodName_;
	private List argDefs_ = new ArrayList();
	private S2Container container_;
	
	/**
	 * 
	 */
	public MethodDefImpl(String methodName) {
		methodName_ = methodName;
	}

	/**
	 * @see org.seasar.framework.container.MethodDef#getMethodName()
	 */
	public String getMethodName() {
		return methodName_;
	}

	/**
	 * @see org.seasar.framework.container.MethodDef#addArgDef(org.seasar.framework.container.ArgDef)
	 */
	public void addArgDef(ArgDef argDef) {
		if (container_ != null) {
			argDef.setContainer(container_);
		}
		argDefs_.add(argDef);
	}
	
	private ArgDef getArgDef(int index) {
		return (ArgDef) argDefs_.get(index);
	}

	/**
	 * @see org.seasar.framework.container.MethodDef#getArgs()
	 */
	public Object[] getArgs() {
		Object[] args = new Object[argDefs_.size()];
		for (int i = 0; i < argDefs_.size(); ++i) {
			args[i] = getArgDef(i).getValue();
		}
		return args;
	}

	/**
	 * @see org.seasar.framework.container.MethodDef#getContainer()
	 */
	public S2Container getContainer() {
		return container_;
	}

	/**
	 * @see org.seasar.framework.container.MethodDef#setContainer(org.seasar.framework.container.S2Container)
	 */
	public void setContainer(S2Container container) {
		container_ = container;
		for (int i = 0; i < argDefs_.size(); ++i) {
			getArgDef(i).setContainer(container);
		}
	}

}
