package org.seasar.framework.container.impl;

import org.seasar.framework.aop.AroundAdvice;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.AspectImpl;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.parser.SelParser;

/**
 * @author higa
 *
 */
public class AspectDefImpl implements AspectDef {

	private AroundAdvice advice_;
	private Pointcut pointcut_;
	private S2Container container_;
	private Expression expression_;

	public AspectDefImpl() {
	}

	public AspectDefImpl(Pointcut pointcut) {
		pointcut_ = pointcut;
	}
	
	public AspectDefImpl(AroundAdvice advice) {
		advice_ = advice;
	}

	public AspectDefImpl(AroundAdvice advice, Pointcut pointcut) {
		advice_ = advice;
		pointcut_ = pointcut;
	}

	/**
	 * @see org.seasar.framework.container.AspectDef#getAspect()
	 */
	public Aspect getAspect() {
		if (advice_ == null) {
			advice_ = (AroundAdvice) expression_.evaluateValue(
				container_.getSelContext());
		}
		return new AspectImpl(advice_, pointcut_);
	}

	/**
	 * @see org.seasar.framework.container.AspectDef#getContainer()
	 */
	public S2Container getContainer() {
		return container_;
	}

	/**
	 * @see org.seasar.framework.container.AspectDef#setContainer(org.seasar.framework.container.S2Container)
	 */
	public void setContainer(S2Container container) {
		container_ = container;
	}

	/**
	 * @see org.seasar.framework.container.AspectDef#setExpression(java.lang.String)
	 */
	public void setExpression(String str) {
		expression_ = new SelParser(str).parseExpression();
	}

}
