package test.org.seasar.system;

import java.rmi.server.UnicastRemoteObject;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.system.JMXService;
import org.seasar.system.JMXUtil;
import org.seasar.system.RMIAdaptor;
import org.seasar.system.RMIAdaptorImpl;
import org.seasar.system.RMINotificationListener;
import org.seasar.system.RMINotificationListenerAdaptor;
import org.seasar.util.SeasarContext;

public class RMIAdaptorImplTest extends JMXTestCase {
	
	private RMIAdaptorImpl _rmiAdaptor;
	private RMIAdaptor _rmiAdaptorStub;
	
	public RMIAdaptorImplTest(String name) {
    	super(name);
  	}

  	public void testRMIAdaptorImpl() throws Throwable {
    	final int num = 1000;
    	String name = JMXUtil.getMBeanName("Hello");
    	Hello hello = (Hello) new Hello();
    	JMXService.registerMBean(hello, name);

    	assertEquals("1", "hello", _rmiAdaptorStub.invoke(name, "greeting", null, null));
    	long start = System.currentTimeMillis();
    	for (int i = 0; i < num; i++) {
      		_rmiAdaptorStub.invoke(name, "greeting", null, null);
    	}
    	System.out.println("RMIAdaptorImplStub millis:" + (System.currentTimeMillis() - start));
  	}
  	
  	public void testNotify() throws Throwable {
  		Notify notify = new Notify();
  		JMXService.registerMBean(notify, NotifyMBean.NAME);
    	
    	NotificationListenerTester listenerTester = new NotificationListenerTester();
    	RMINotificationListenerAdaptor rmiListenerAdaptor =
    		new RMINotificationListenerAdaptor(NotifyMBean.NAME, listenerTester, SeasarContext.getInstance());
    	RMINotificationListener rmiNotificationListenerStub = (RMINotificationListener)
    		UnicastRemoteObject.exportObject(rmiListenerAdaptor);
    	
    	String listenerName = _rmiAdaptorStub.addNotificationListener(
    		NotifyMBean.NAME, rmiNotificationListenerStub);
    	System.out.println("listenerName:" + listenerName);
    	assertNotNull("1", listenerName);
    	
    	notify.sendMessage("Hello");
    	assertEquals("2", true, listenerTester.isCalled());
    	
    	_rmiAdaptorStub.removeNotificationListener(listenerName);
    	assertEquals("3", false, JMXService.isRegistered(listenerName));
  	}

  	protected void setUp() throws Exception {
  		super.setUp();
  		_rmiAdaptor = new RMIAdaptorImpl();
    	_rmiAdaptorStub = (RMIAdaptor) UnicastRemoteObject.exportObject(_rmiAdaptor);
    }

	protected void tearDown() throws Exception {
		if (UnicastRemoteObject.unexportObject(_rmiAdaptor, true)) {
			System.out.println("unexportObject success");
		} else {
			System.out.println("unexportObject fail");
		}
		super.tearDown();
  	}

  	public static Test suite ( ) {
    	return new TestSuite(RMIAdaptorImplTest.class);
  	}

  	public static void main (String[] args) {
    	junit.textui.TestRunner.main(new String[]{RMIAdaptorImplTest.class.getName()});
  	}
}