package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.DoubleExp;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.StringExp;
import org.seasar.nazuna.ToStringExp;
import org.seasar.nazuna.ToTimestampExp;

public class ToStringExpTest extends TestCase {

    public ToStringExpTest(String name) {
        super(name);
    }

    public void testEvaluate() throws Exception {
        Expression exp = new ToStringExp(new DoubleExp(new Double(1)), "000");
        assertEquals("1", "001", exp.evaluateValue(null));
        
        Expression exp2 = new ToStringExp(new ToTimestampExp(new StringExp("20021114"),
        	"yyyyMMdd"), "yyyy/MM/dd");
        assertEquals("2", "2002/11/14", exp2.evaluateValue(null));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(ToStringExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{ToStringExpTest.class.getName()});
    }
}