package test.org.seasar.nazuna;

import java.io.File;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.nazuna.NazunaTransAttribute;
import org.seasar.nazuna.RuletClassLoader;
import org.seasar.nazuna.RuletCompiler;
import org.seasar.nazuna.RuletDeployer;
import org.seasar.nazuna.RuletFacade;

import test.org.seasar.transaction.TransactionTestCase;

public class RuletFacadeTest extends TransactionTestCase {

    public RuletFacadeTest(String name) {
        super(name);
    }

    public void testCreate() throws Exception {
    	String className = "test.org.seasar.nazuna.HelloRulet";
    	File classFile = RuletCompiler.getClassFile(className);
    	RuletClassLoader loader = new RuletClassLoader();
    	Class ruletClass = loader.defineClass(className, classFile);
    	assertNotNull("1", RuletFacade.create(ruletClass));
    }
    
    public void testExecute() throws Exception {
    	String className = "test.org.seasar.nazuna.HelloRulet";
    	File classFile = RuletCompiler.getClassFile(className);
    	RuletClassLoader loader = new RuletClassLoader();
    	Class ruletClass = loader.defineClass(className, classFile);
    	RuletFacade facade = RuletFacade.create(ruletClass);
    	assertEquals("1", "hello", facade.execute(null));
    }
    
    public void testValidate() throws Exception {
    	String className = "test.org.seasar.nazuna.Test2Rulet";
    	File classFile = RuletCompiler.getClassFile(className);
    	RuletClassLoader loader = new RuletClassLoader();
    	Class ruletClass = loader.defineClass(className, classFile);
    	RuletFacade facade = RuletFacade.create(ruletClass);
    	try {
    		facade.execute(new Object[]{null});
    		fail("1");
    	} catch (Exception ex) {
    		System.out.println(ex);
    	}
    }
    
    public void testSupports() throws Exception {
    	String className = "test.org.seasar.nazuna.HelloRulet";
    	RuletDeployer deployer = new RuletDeployer(className);
    	deployer.deploy();
    	RuletFacade facade = deployer.getRuletFacade();
    	assertEquals("1", NazunaTransAttribute.SUPPORTS, facade.getTransAttribute());
    }
    
    public void testRequired() throws Exception {
    	String className = "test.org.seasar.nazuna.TestRequiredTxRulet";
    	RuletDeployer deployer = new RuletDeployer(className);
    	deployer.deploy();
    	RuletFacade facade = deployer.getRuletFacade();
    	assertEquals("1", NazunaTransAttribute.REQUIRED, facade.getTransAttribute());
    	assertEquals("2", Boolean.TRUE, facade.execute(null));
    }
    
    public void testRequiresNew() throws Exception {
    	String className = "test.org.seasar.nazuna.TestRequiresNewTxRulet";
    	RuletDeployer deployer = new RuletDeployer(className);
    	deployer.deploy();
    	RuletFacade facade = deployer.getRuletFacade();
    	assertEquals("1", NazunaTransAttribute.REQUIRES_NEW, facade.getTransAttribute());
    	assertEquals("2", Boolean.TRUE, facade.execute(null));
    }
    
    public void testMandatory() throws Exception {
    	String className = "test.org.seasar.nazuna.TestMandatoryTxRulet";
    	RuletDeployer deployer = new RuletDeployer(className);
    	deployer.deploy();
    	RuletFacade facade = deployer.getRuletFacade();
    	assertEquals("1", NazunaTransAttribute.MANDATORY, facade.getTransAttribute());
    }

    protected void setUp() throws Exception {
    	super.setUp();
    }

    protected void tearDown() throws Exception {
    	super.tearDown();
    }

    public static Test suite ( ) {
        return new TestSuite(RuletFacadeTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{RuletFacadeTest.class.getName()});
    }
}