package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.PropertyType;
import org.seasar.nazuna.ResultType;
import org.seasar.nazuna.ResultTypeBuilder;

public class ResultTypeBuilderTest extends TestCase {

    public ResultTypeBuilderTest(String name) {
        super(name);
    }
    
    public void testParse() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Employee.xml";
    	ResultType resultType = ResultTypeBuilder.parse(xmlFileName);
    	assertNotNull("1", resultType);
    	assertEquals("2", Employee.class, resultType.getResultClass());
    	assertEquals("3", 8, resultType.getPropertyTypeSize());
    	PropertyType propertyType = resultType.getPropertyType(0);
    	assertNotNull("4", propertyType);
    	assertEquals("5", "EmployeeNo", propertyType.getName());
    	assertEquals("6", "empno", propertyType.getColumnName());
    }
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(ResultTypeBuilderTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{ResultTypeBuilderTest.class.getName()});
    }
}