package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.Expression;
import org.seasar.nazuna.GreaterEqualExp;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.NullExp;

public class GreaterEqualExpTest extends TestCase {

    public GreaterEqualExpTest(String name) {
        super(name);
    }

    public void testEvaluate() throws Exception {
    	String s = "1234567890";
    	String s2 = "1234567891";
        Integer i = new Integer(s);
        Integer i2 = new Integer(s2);
        IntegerExp iExp = new IntegerExp(i);
        IntegerExp i2Exp = new IntegerExp(i2);
        GreaterEqualExp geExp = new GreaterEqualExp(iExp, iExp);
        assertEquals("1", true, geExp.evaluate(null));
        
        GreaterEqualExp ge2Exp = new GreaterEqualExp(i2Exp, iExp);
        assertEquals("2", true, ge2Exp.evaluate(null));
        
        GreaterEqualExp ge3Exp = new GreaterEqualExp(iExp, i2Exp);
        assertEquals("3", false, ge3Exp.evaluate(null));
        
        Expression nullExp = new NullExp();
        GreaterEqualExp ge4Exp = new GreaterEqualExp(iExp, nullExp);
        assertEquals("4", false, ge4Exp.evaluate(null));
        
        GreaterEqualExp ge5Exp = new GreaterEqualExp(nullExp, iExp);
        assertEquals("5", false, ge5Exp.evaluate(null));
        
        GreaterEqualExp ge6Exp = new GreaterEqualExp(nullExp, nullExp);
        assertEquals("6", false, ge6Exp.evaluate(null));

    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(GreaterEqualExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{GreaterEqualExpTest.class.getName()});
    }
}