package org.seasar.util;

import java.math.BigDecimal;

public final class MathUtil {
	
	public static Integer ZERO_INTEGER = new Integer(0);
	public static Integer ONE_INTEGER = new Integer(1);
	public static Long ZERO_LONG = new Long(0);
	public static BigDecimal ZERO_BIGDECIMAL = new BigDecimal(0);
	public static BigDecimal HALF_BIGDECIMAL = new BigDecimal(0.5d);
	
	private MathUtil() {}
	
	public static Number getZero(Number num) {
		if (num instanceof Integer) {
			return ZERO_INTEGER;
		} else if (num instanceof BigDecimal) {
			return ZERO_BIGDECIMAL;
		} else if (num instanceof Long) {
			return ZERO_LONG;
		} else {
			return null;
		}
	}
	
	public static Integer inclement(Integer arg1) {
		if (arg1 == null) {
            return null;
        }
        return new Integer(arg1.intValue() + 1);
	}
	
	public static Integer add(Integer arg1, Integer arg2) {
		if (arg1 == null || arg2 == null) {
            return null;
        }
        return new Integer(arg1.intValue() + arg2.intValue());
	}
	
	public static Number add(Number arg1, Number arg2) {
		if (arg1 == null || arg2 == null) {
            return null;
        }
        if (arg1 instanceof Integer) {
        	Integer i1 = (Integer) arg1;
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Integer(i1.intValue() + i2.intValue());
        	}
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(i1.intValue() + d2.doubleValue());
        	}
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Long(i1.intValue() + l2.longValue());
        	}
        }
        if (arg1 instanceof Long) {
        	Long l1 = (Long) arg1;
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Long(l1.longValue() + l2.longValue());
        	}
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Long(l1.longValue() + i2.intValue());
        	}
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(l1.longValue() + d2.doubleValue());
        	}
        }
        if (arg1 instanceof Double) {
        	Double d1 = (Double) arg1;
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(d1.doubleValue() + d2.doubleValue());
        	}
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Double(d1.doubleValue() + i2.intValue());
        	}
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Double(d1.doubleValue() + l2.longValue());
        	}	
        }
		throw new SeasarRuntimeException("ESSR0028", new Object[]{
			arg1.getClass(), arg2.getClass()});	
	}
	
	public static Number subtract(Number arg1, Number arg2) {
		if (arg1 == null || arg2 == null) {
            return null;
        }
        if (arg1 instanceof Integer) {
        	Integer i1 = (Integer) arg1;
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Integer(i1.intValue() - i2.intValue());
        	}
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(i1.intValue() - d2.doubleValue());
        	}
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Long(i1.intValue() - l2.longValue());
        	}
        }
        if (arg1 instanceof Long) {
        	Long l1 = (Long) arg1;
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Long(l1.longValue() - l2.longValue());
        	}
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Long(l1.longValue() - i2.intValue());
        	}
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(l1.longValue() - d2.doubleValue());
        	}
        }
        if (arg1 instanceof Double) {
        	Double d1 = (Double) arg1;
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(d1.doubleValue() - d2.doubleValue());
        	}
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Double(d1.doubleValue() - i2.intValue());
        	}
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Double(d1.doubleValue() - l2.longValue());
        	}	
        }
		throw new SeasarRuntimeException("ESSR0028", new Object[]{
			arg1.getClass(), arg2.getClass()});	
	}
	
	public static Number multiply(Number arg1, Number arg2) {
		if (arg1 == null || arg2 == null) {
            return null;
        }
        if (arg1 instanceof Integer) {
        	Integer i1 = (Integer) arg1;
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Integer(i1.intValue() * i2.intValue());
        	}
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(i1.intValue() * d2.doubleValue());
        	}
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Long(i1.intValue() * l2.longValue());
        	}
        }
        if (arg1 instanceof Long) {
        	Long l1 = (Long) arg1;
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Long(l1.longValue() * l2.longValue());
        	}
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Long(l1.longValue() * i2.intValue());
        	}
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(l1.longValue() * d2.doubleValue());
        	}
        }
        if (arg1 instanceof Double) {
        	Double d1 = (Double) arg1;
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(d1.doubleValue() * d2.doubleValue());
        	}
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Double(d1.doubleValue() * i2.intValue());
        	}
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Double(d1.doubleValue() * l2.longValue());
        	}	
        }
		throw new SeasarRuntimeException("ESSR0028", new Object[]{
			arg1.getClass(), arg2.getClass()});	
	}
	
	public static Number divide(Number arg1, Number arg2) {
		if (arg1 == null || arg2 == null) {
            return null;
        }
        if (arg1 instanceof Integer) {
        	Integer i1 = (Integer) arg1;
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Integer(i1.intValue() / i2.intValue());
        	}
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(i1.intValue() / d2.doubleValue());
        	}
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Long(i1.intValue() / l2.longValue());
        	}
        }
        if (arg1 instanceof Long) {
        	Long l1 = (Long) arg1;
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Long(l1.longValue() / l2.longValue());
        	}
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Long(l1.longValue() / i2.intValue());
        	}
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(l1.longValue() / d2.doubleValue());
        	}
        }
        if (arg1 instanceof Double) {
        	Double d1 = (Double) arg1;
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(d1.doubleValue() / d2.doubleValue());
        	}
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Double(d1.doubleValue() / i2.intValue());
        	}
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Double(d1.doubleValue() / l2.longValue());
        	}	
        }
		throw new SeasarRuntimeException("ESSR0028", new Object[]{
			arg1.getClass(), arg2.getClass()});	
	}
	
	public static Number mod(Number arg1, Number arg2) {
		if (arg1 == null || arg2 == null) {
            return null;
        }
        if (arg1 instanceof Integer) {
        	Integer i1 = (Integer) arg1;
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Integer(i1.intValue() % i2.intValue());
        	}
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(i1.intValue() % d2.doubleValue());
        	}
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Long(i1.intValue() % l2.longValue());
        	}
        }
        if (arg1 instanceof Long) {
        	Long l1 = (Long) arg1;
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Long(l1.longValue() % l2.longValue());
        	}
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Long(l1.longValue() % i2.intValue());
        	}
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(l1.longValue() % d2.doubleValue());
        	}
        }
        if (arg1 instanceof Double) {
        	Double d1 = (Double) arg1;
        	if (arg2 instanceof Double) {
        		Double d2 = (Double) arg2;
        		return new Double(d1.doubleValue() % d2.doubleValue());
        	}
        	if (arg2 instanceof Integer) {
        		Integer i2 = (Integer) arg2;
        		return new Double(d1.doubleValue() % i2.intValue());
        	}
        	if (arg2 instanceof Long) {
        		Long l2 = (Long) arg2;
        		return new Double(d1.doubleValue() % l2.longValue());
        	}	
        }
		throw new SeasarRuntimeException("ESSR0028", new Object[]{
			arg1.getClass(), arg2.getClass()});	
	}

	public static Integer mod(Integer arg1, Integer arg2) {
		if (arg1 == null || arg2 == null) {
            return null;
        }
		return new Integer(arg1.intValue() % arg2.intValue());
	}
	
	public static Long mod(Long arg1, Long arg2) {
		if (arg1 == null || arg2 == null) {
            return null;
        }
		return new Long(arg1.longValue() % arg2.longValue());
	}
	
	public static BigDecimal mod(BigDecimal arg1, BigDecimal arg2) {
		if (arg1 == null || arg2 == null) {
            return null;
        }
		return new BigDecimal(arg1.doubleValue() % arg2.doubleValue());
	}
	
	public static Number abs(Number arg1) {
		if (arg1 == null) {
            return null;
        }
		if (arg1 instanceof Integer) {
			Integer i1 = (Integer) arg1;
			if (i1.compareTo(ZERO_INTEGER) >= 0) {
				return i1;
			} else {
				return new Integer(i1.intValue()*(-1));
			}
		} else if (arg1 instanceof BigDecimal) {
			BigDecimal b1 = (BigDecimal) arg1;
			return b1.abs();
		} else if (arg1 instanceof Long) {
			Long l1 = (Long) arg1;
			if (l1.compareTo(ZERO_LONG) >= 0) {
				return l1;
			} else {
				return new Long(l1.longValue()*(-1));
			}
		}
		throw new SeasarRuntimeException("ESSR0340", new Object[]{arg1});	
	}
	
	public static int abs(int a) {
		return (a < 0) ? -a : a;
    }

    public static long abs(long a) {
		return (a < 0) ? -a : a;
    }
	
	public static Integer abs(Integer arg1) {
		if (arg1 == null) {
            return null;
        }
		if (arg1.compareTo(ZERO_INTEGER) >= 0) {
			return arg1;
		} else {
			return new Integer(arg1.intValue()*(-1));
		}
	}
	
	public static Long abs(Long arg1) {
		if (arg1 == null) {
            return null;
        }
		if (arg1.compareTo(ZERO_LONG) >= 0) {
			return arg1;
		} else {
			return new Long(arg1.longValue()*(-1));
		}
	}
	
	public static BigDecimal abs(BigDecimal arg1) {
		if (arg1 == null) {
            return null;
        }
		return arg1.abs();
	}
	
	public static Integer increment(Integer arg1) {
		if (arg1 == null) {
            return ZERO_INTEGER;
        }
		return new Integer(arg1.intValue() + 1);
	}
	
	public static int sign(int arg) {
		if (arg > 0) {
            return 1;
        } else if (arg < 0) {
        	return -1;
		} else {
			return 0;
		}
	}
	
	public static int sign(long arg) {
		if (arg > 0) {
            return 1;
        } else if (arg < 0) {
        	return -1;
		} else {
			return 0;
		}
	}
	
	public static int sign(double arg) {
		if (arg > 0) {
            return 1;
        } else if (arg < 0) {
        	return -1;
		} else {
			return 0;
		}
	}
	
	public static int sign(BigDecimal arg) {
		int sign = arg.compareTo(ZERO_BIGDECIMAL);
		if (sign > 0) {
			return 1;
		} else if (sign < 0) {
			return -1;
		} else {
			return 0;
		}
	}
	
	public static double trunc(double arg) {
		if (arg > 0) {
            return Math.floor(arg);
        } else if (arg < 0) {
        	return Math.ceil(arg);
		} else {
			return 0;
		}
	}
	
	public static BigDecimal trunc(BigDecimal arg) {
		int sign = arg.compareTo(ZERO_BIGDECIMAL);
		if (sign > 0) {
            return floor(arg);
        } else if (sign < 0) {
        	return ceil(arg);
		} else {
			return ZERO_BIGDECIMAL;
		}
	}
	
	public static BigDecimal acos(BigDecimal a) {
		return new BigDecimal(StrictMath.acos(a.doubleValue()));
    }
    
    public static BigDecimal asin(BigDecimal a) {
		return new BigDecimal(StrictMath.asin(a.doubleValue()));
    }
    
    public static BigDecimal atan(BigDecimal a) {
		return new BigDecimal(StrictMath.atan(a.doubleValue()));
    }
    
    public static BigDecimal atan2(BigDecimal y, BigDecimal x) {
		return new BigDecimal(StrictMath.atan2(y.doubleValue(), x.doubleValue()));
    }
    
    public static BigDecimal ceil(BigDecimal a) {
		return new BigDecimal(StrictMath.ceil(a.doubleValue()));
    }
    
    public static BigDecimal cos(BigDecimal a) {
		return new BigDecimal(StrictMath.cos(a.doubleValue()));
    }
    
    public static BigDecimal degrees(BigDecimal angrad) {
		return new BigDecimal(angrad.doubleValue() * 180.0 / Math.PI);
    }
    
    public static BigDecimal exp(BigDecimal a) {
		return new BigDecimal(StrictMath.exp(a.doubleValue()));
    }
    
    public static BigDecimal floor(BigDecimal a) {
		return new BigDecimal(StrictMath.floor(a.doubleValue()));
    }
    
    public static BigDecimal ln(BigDecimal a) {
		return new BigDecimal(StrictMath.log(a.doubleValue()));
    }
    
    public static BigDecimal pow(BigDecimal a, BigDecimal b) {
		return new BigDecimal(StrictMath.pow(a.doubleValue(), b.doubleValue()));
    }
    
    public static BigDecimal radians(BigDecimal angdeg) {
		return new BigDecimal(angdeg.doubleValue() / 180.0 * Math.PI);
    }
    
    public static BigDecimal random() {
        return new BigDecimal(Math.random());
    }
    
    public static Long round(BigDecimal a) {
		return new Long(Math.round(a.doubleValue()));
    }
    
    public static BigDecimal sin(BigDecimal a) {
		return new BigDecimal(StrictMath.sin(a.doubleValue()));
    }
    
    public static BigDecimal sqrt(BigDecimal a) {
		return new BigDecimal(StrictMath.sqrt(a.doubleValue()));
    }
    
    public static BigDecimal tan(BigDecimal a) {
		return new BigDecimal(StrictMath.tan(a.doubleValue()));
    }
    
    public static BigDecimal sum(BigDecimal arg1, BigDecimal arg2) {
		if (arg1 == null) {
            arg1 = ZERO_BIGDECIMAL;
        }
        if (arg2 == null) {
            arg2 = ZERO_BIGDECIMAL;
        }
        return arg1.add(arg2);
	}
    
    public static Comparable max(final Comparable left, final Comparable right) {
        if (left != null && right != null) {
            if (left.compareTo(right) >= 0) {
                return left;
            } else {
                return right;
            }
        } else if (left == null) {
            return right;
        } else {
            return left;
        }
    }

    public static Comparable min(final Comparable left, final Comparable right) {
        if (left != null && right != null) {
            if (left.compareTo(right) <= 0) {
                return left;
            } else {
                return right;
            }
        } else if (left == null) {
            return right;
        } else {
            return left;
        }
    }

}
