package org.seasar.util;

public final class LineUtil {

    public static final String LINE_SP = System.getProperty("line.separator");
    public static final int LINE_SP_LEN = LINE_SP.length();

    private LineUtil() {
    }

    public static String removeFirstLine(final String lines) {
        int pos = lines.indexOf(LINE_SP);
        if (pos == -1) {
            return lines;
        }
        pos += LINE_SP_LEN;
        return lines.substring(pos);
    }

    public static String getLastLine(String lines) {
        if (lines.endsWith(LINE_SP)) {
            lines = lines.substring(0, lines.length() - LINE_SP_LEN);
        }
        int pos = lines.lastIndexOf(LINE_SP);
        if (pos == -1) {
            return lines;
        }
        pos += LINE_SP_LEN;
        return lines.substring(pos);
    }
}