package org.seasar.nazuna.amf;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.seasar.log.Logger;
import org.seasar.util.ThrowableUtil;

public final class AMFGateway extends HttpServlet {

	public AMFGateway() {
	}

	public final void doGet(final HttpServletRequest request, final HttpServletResponse response)
            throws IOException, ServletException {

        response.getWriter().write("AMFGateway is running.");
    }

    public final void doPost(final HttpServletRequest request, final HttpServletResponse response)
            throws IOException, ServletException {

		try {
			AMFMessage requestMessage = readMessage(request);
			AMFMessage responseMessage = processMessage(request, requestMessage);
			writeMessage(response, responseMessage);
		} catch (Throwable t) {
			Throwable cause = ThrowableUtil.getCause(t);
			Logger.getLogger(AMFGateway.class).log(cause);
			throw new ServletException(cause);
		}
    }
    
    public final AMFMessage readMessage(final HttpServletRequest request)
            throws IOException, ServletException {

		InputStream is = request.getInputStream();
		if (!(is instanceof BufferedInputStream)) {
			is = new BufferedInputStream(is);
		}
        DataInputStream inputStream = new DataInputStream(is);
		AMFReader reader = new AMFReader(inputStream);
		return reader.read();
    }
    
    public final AMFMessage processMessage(HttpServletRequest request,
			AMFMessage requestMessage) throws IOException {

		AMFMessage responseMessage = new AMFMessage();
		for (int i = 0; i < requestMessage.getBodyCount(); ++i) {
			AMFBody requestBody = requestMessage.getBody(i);
			AMFBody responseBody = processBody(request, requestBody);
			responseMessage.addBody(responseBody);
		}
		return responseMessage;
	}
	
	public final AMFBody processBody(HttpServletRequest request,
			AMFBody requestBody) {

		try {
			Object result = requestBody.invoke(request);
			String target = requestBody.getResponse() + "/onResult";
			return new AMFBody(target, "null", result);
		} catch (Throwable t) {
			String target = requestBody.getResponse() + "/onStatus";
			return new AMFBody(target, "null", new AMFError(t));
		}
	}

	public final void writeMessage(HttpServletResponse response,
			AMFMessage responseMessage) throws IOException {

		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		DataOutputStream outputStream = new DataOutputStream(baos);
		AMFWriter writer = new AMFWriter(outputStream, responseMessage);
		writer.write();
		response.setContentType("application/x-amf");
		response.setContentLength(baos.size());
		baos.writeTo(response.getOutputStream());
		outputStream.flush();
	}
}
