package org.seasar.nazuna.amf;

import org.seasar.util.ThrowableUtil;

public final class AMFError {

	private String _code = "SERVER.PROCESSING";
	private String _type;
	private String _level = "error";
	private String _details;
	private String _description;
	
	public AMFError() {
	}
	
	public AMFError(Throwable t) {
		Throwable cause = ThrowableUtil.getCause(t);
		setType(cause.getClass().getName());
		setDetails(getStackTraceString(cause));
		setDescription(cause.getMessage());
	}

	public final String getCode() {
		return _code;
	}
	
	public final void setCode(String code) {
		_code = code;
	}

	public final String getType() {
		return _type;
	}

	public final void setType(String type) {
		_type = type;
	}

	public final String getLevel() {
		return _level;
	}

	public final void setLevel(String level) {
		_level = level;
	}

	public final String getDetails() {
		return _details;
	}

	public final void setDetails(String details) {
		_details = details;
	}

	public final String getDescription() {
		return _description;
	}

	public final void setDescription(String description) {
		_description = description;
	}
	
	private static String getStackTraceString(Throwable t) {
		StackTraceElement[] elements = t.getStackTrace();
		StringBuffer buf = new StringBuffer(t.toString());
		buf.append('\n');
		for (int i = 0; i < elements.length; ++i) {
			buf.append(elements[i].toString());
			buf.append('\n');
		}
		return buf.toString();
	}
}
