package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public class WhenTag extends RuleStatementContainerImpl {

	private BooleanExpression _conditionExp;
	
	public WhenTag(Object parent, String location, BooleanExpression conditionExp) {
		super(parent, location);
		Assertion.assertNotNull("conditionExp", conditionExp);
		
		_conditionExp = conditionExp;
	}
	
	public final void execute(RuleContext ruleContext) throws SeasarException {
		try {
			if (_conditionExp.evaluate(ruleContext)) {
				ruleContext.breakWhen();
				for (int i = 0; i < _ruleStatements.length; ++i) {
					RuleStatement ruleStatement = _ruleStatements[i];
					ruleStatement.execute(ruleContext);
					if (ruleContext.isReturned() || ruleContext.isThrowed() ||
							ruleContext.isBreaked() || ruleContext.isContinued()) {
								
						return;
					}
				}
			}
		} catch (Throwable t) {
			ruleContext.setThrowable(t, getLocation());
		}
	}
}
