package org.seasar.nazuna;

import java.lang.reflect.Array;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class NewArrayExp implements Expression {

	public static final NewArrayExp EMPTY_ARRAY_EXP =
		new NewArrayExp(Object.class, 0, Expression.EMPTY_EXPRESSIONS);
	private final Class _clazz;
    private final int _arraySize;
    private final Expression[] _argExps;

    public NewArrayExp(final Class clazz, final int arraySize,
    		final Expression[] argExps) {
    			
        Assertion.assertNotNull("clazz", clazz);
        Assertion.assertTrue(arraySize >= 0, "ESSR0004", "arraySize");
        Assertion.assertNotNull("argExps", argExps);
        
        _clazz = clazz;
        _arraySize = arraySize;
        _argExps = argExps;
    }

    public Object evaluateValue(final RuleContext ruleContext)
    		throws SeasarException {
    			
    	Object[] array = (Object[]) Array.newInstance(_clazz, _arraySize);
    	for (int i = 0; i < _argExps.length; ++i) {
    		array[i] = _argExps[i].evaluateValue(ruleContext);
    	}
    	return array;
    }
}
