package org.seasar.nazuna;

import java.util.Map;

import org.seasar.util.Assertion;
import org.seasar.util.EMap;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public final class InputType {

	private EMap _argTypes = new EMap();
	
	public InputType() {
	}

	public final void addArgType(ArgType argType) {
		Assertion.assertNotNull("argType", argType);
		
		String name = argType.getName();
		Assertion.assertNotExist(name, _argTypes.put(name, argType));
	}
	
	public final int getArgTypeSize() {
		return _argTypes.size();
	}
	
	public final ArgType getArgType(String name) {
		return (ArgType) _argTypes.get(name);
	}
	
	public final ArgType getArgType(int index) {
		return (ArgType) _argTypes.get(index);
	}
	
	public final boolean containsArgType(String name) {
		return _argTypes.containsKey(name);
	}
	
	public final Map createArgs(Map parameters) throws SeasarException {
		Map args = new SMap();
		if (parameters == null) {
			for (int i = 0; i < _argTypes.size(); ++i) {
				ArgType argType = (ArgType) _argTypes.get(i);
				Arg arg = new Arg(argType, null);
				args.put(argType.getName(), arg);
			}
		} else {
			for (int i = 0; i < _argTypes.size(); ++i) {
				ArgType argType = (ArgType) _argTypes.get(i);
				Object value = parameters.get(argType.getName());
				Arg arg = new Arg(argType, value);
				args.put(argType.getName(), arg);
			}
		}
		return args;
	}
}
