package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class ExecuteRuletExp implements Expression {

	private final Expression _nameExp;
	private final Expression[] _argExps;

	public ExecuteRuletExp(final Expression nameExp, Expression[] argExps) {
		Assertion.assertNotNull("nameExp", nameExp);
		Assertion.assertNotNull("argExps", argExps);
    	
		_nameExp = nameExp;
		_argExps = argExps;
	}

	public Object evaluateValue(final RuleContext ruleContext)
			throws SeasarException {
    			
    	Object[] args = new Object[_argExps.length];
		for (int i = 0; i < _argExps.length; ++i) {
			args[i] = _argExps[i].evaluateValue(ruleContext);
		}
		String name = (String) _nameExp.evaluateValue(ruleContext);
		return Nazuna.executeRulet(name, args);
	}
}
