package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class Arg {

	private ArgType _argType;
	private Object _value;
	
	public Arg(ArgType argType, Object value) throws SeasarException {
		Assertion.assertNotNull("argType", argType);
		argType.validate(value);
		
		_argType = argType;
		_value = value;
	}
	
	public ArgType getArgType() {
		return _argType;
	}
	
	public Object getValue() {
		return _value;
	}

}
