package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

abstract class AbstractCompareExp implements BooleanExpression {

    private Expression _arg1Exp;
    private Expression _arg2Exp;

    public AbstractCompareExp(Expression arg1Exp, Expression arg2Exp) {
		Assertion.assertNotNull("arg1Exp", arg1Exp);
		Assertion.assertNotNull("arg2Exp", arg2Exp);

        _arg1Exp = arg1Exp;
        _arg2Exp = arg2Exp;
    }

    protected Comparable getArg1(RuleContext ruleContext) throws SeasarException {
        return (Comparable) _arg1Exp.evaluateValue(ruleContext);
    }

    protected Comparable getArg2(RuleContext ruleContext) throws SeasarException {
        return (Comparable) _arg2Exp.evaluateValue(ruleContext);
    }
}
