package org.seasar.log;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.seasar.message.MessageFormatter;

public final class Logger {

    private static Map _loggerMap = new HashMap();

    private Category _category;
	
    private Logger(final Class clazz) {
        _category = Category.getInstance(clazz);
    }

    public static final Logger getLogger(final Class clazz) {
        Logger logger = (Logger) _loggerMap.get(clazz);
        if (logger == null) {
            synchronized (_loggerMap) {
                if (logger == null) {
                    logger = new Logger(clazz);
                    _loggerMap.put(clazz, logger);
                }
            }
        }
        return logger;
    }

    public final boolean isDebugEnabled() {
        return _category.isDebugEnabled();
    }

    public final void debug(final Object message, final Throwable throwable) {
        if (isDebugEnabled()) {
            _category.debug(message, throwable);
        }
    }

    public final void debug(final Object message) {
        if (isDebugEnabled()) {
            _category.debug(message);
        }
    }

    public final boolean isInfoEnabled() {
        return _category.isInfoEnabled();
    }

    public final void info(final Object message, final Throwable throwable) {
        if (isInfoEnabled()) {
            _category.info(message, throwable);
        }
    }

    public final void info(final Object message) {
        if (isInfoEnabled()) {
            _category.info(message);
        }
    }

    public final void warn(final Object message, final Throwable throwable) {
        _category.warn(message, throwable);
    }

    public final void warn(final Object message) {
        _category.warn(message);
    }

    public final void error(final Object message, final Throwable throwable) {
        _category.error(message, throwable);
    }

    public final void error(final Object message) {
        _category.error(message);
    }

    public final void fatal(final Object message, final Throwable throwable) {
        _category.fatal(message, throwable);
    }

    public final void fatal(final Object message) {
        _category.fatal(message);
    }

    public final void log(final Priority priority, final Object message) {
        _category.log(priority, message);
    }

    public final void log(final Priority priority, final Object message, final Throwable throwable) {
        _category.log(priority, message, throwable);
    }

    public final void log(final Throwable throwable) {
        log("ESSR0017", new Object[]{throwable}, throwable);
    }

    public final void log(final String messageCode, final Object[] arguments) {
        log(messageCode, arguments, null);
    }

    public final void log(final String messageCode, final Object[] arguments,
            final Throwable throwable) {

        Priority priority = getPriority(messageCode.charAt(0));
        if (_category.isEnabledFor(priority)) {
            String message = MessageFormatter.getMessage(messageCode, arguments);
            log(priority, message, throwable);
        }
    }

    private static Priority getPriority(final char messageType) {
        switch (messageType) {
        case 'D':
            return Priority.DEBUG;
        case 'I':
            return Priority.INFO;
        case 'W':
            return Priority.WARN;
        case 'E':
            return Priority.ERROR;
        case 'F':
            return Priority.FATAL;
        default:
            throw new IllegalArgumentException(
                    MessageFormatter.getMessage("ESSR0022", new Object[]{String.valueOf(messageType)}));
        }
    }
}