package org.seasar.eclipse;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;


public final class FileUtil {

	private static final int BUF_SIZE = 8192;
	
	private FileUtil() {
	}
	
	public static void copyFile(File fromFile, File toFile) throws IOException {
		BufferedInputStream in = new BufferedInputStream(new FileInputStream(fromFile));
		BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toFile));
		try {
			byte[] buf = new byte[BUF_SIZE];
			int n;
			while ((n = in.read(buf)) >= 0) {
				out.write(buf,0,n);
			}
		} finally {
			in.close();
			out.close();
		}
	}
	
	public static String readText(File file) throws IOException {
		BufferedReader in = new BufferedReader(new FileReader(file));
		StringBuffer buf = new StringBuffer(BUF_SIZE);
		try {
			String line = null;
			while ((line = in.readLine()) != null) {
				buf.append(line);
				buf.append('\n');
			}
		} finally {
			in.close();
		}
		return buf.toString();
	}

	public static void writeText(File file, String text) throws IOException {
		BufferedWriter out = new BufferedWriter(new FileWriter(file));
		out.write(text);
		out.close();
	}


}
