/*
class test.seasar.unit.SObjectTest extends seasar.unit.TestCase
*/
if (test.seasar.lang.SObjectTest == null) {
	#include "seasar/lang/SObject.as"
	#include "seasar/unit/TestCase.as"
	
	seasar.lang.SObject.defineClass("test.seasar.lang.SObjectTest", seasar.unit.TestCase);
		
	var proto = test.seasar.lang.SObjectTest.prototype;
	
	proto.testDefineClass = function() {
		var oldFoo = _global.Foo;
		var clazz = seasar.lang.SObject.defineClass("Foo");
		this.assertNotNull(clazz);
		this.assertEquals(typeof clazz, "function");
		this.assertEquals("Foo", clazz.name);
		this.assertEquals(clazz, Foo);
		this.assertNotNull(new Foo());
		var f = new Foo();
		this.assertEquals(f.constructor, Foo);
		_global.Foo = oldFoo;
	}
	
	proto.testDefineClass2 = function() {
		seasar.lang.SObject.defineClass("test.seasar.lang.SObjectTest.Foo");
		this.assertNotNull(test.seasar.lang.SObjectTest.Foo);
	}
	
	proto.testSuperClass = function() {
		var Foo = seasar.lang.SObject.defineClass("test.seasar.lang.SObjectTest.Foo");
		Foo.prototype.a = "111";
		Foo.prototype.hoge = function() {
			return "222";
		}
		var Foo2 = seasar.lang.SObject.defineClass("test.seasar.lang.SObjectTest.Foo2",
			test.seasar.lang.SObjectTest.Foo);
		var f2 = new Foo2();
		this.assertEquals(Foo, Foo2.prototype.__constructor__);
		this.assertEquals("111", f2.a);
		this.assertDefined(f2.hoge);
	}
	
	proto.testProperties = function() {
		var Foo = seasar.lang.SObject.defineClass("test.seasar.lang.SObjectTest.Foo", null, ["a", "b"]);
		var f = new Foo();
		trace(f);
		this.assertDefined(f.a);
		this.assertDefined(f.b);
	}
	
	proto.testConstructor = function() {
		var Foo = seasar.lang.SObject.defineClass("test.seasar.lang.SObjectTest.Foo", null, ["a", "b"],
			function() {
				this.a = "111";
				this.b = "222";
			});
		var f = new Foo();
		this.assertEquals("111", f.a);
		this.assertEquals("222", f.b);
	}

	delete proto;
}