/*
class seasar.lang.SObject

public static:
Function defineClass(String className, Function superClass,
                                        Array propertyNames, Function constructorFunc)

public:
String toString()

private static:
Function defineClazz(String className, Function constructorFunc)
void setSuperClass(Function subClass, Function superClass)
void defineProperties(Function clazz, Array propertyNames)

private:
void __resolve(String propertyName)

*/
if (seasar.lang.SObject === undefined) {
	if (_global.seasar === undefined) {
		_global.seasar = new Object();
	}
	if (seasar.lang === undefined) {
		seasar.lang = new Object();
	}
	seasar.lang.SObject = function() {
	}
	
	seasar.lang.SObject.name = "seasar.lang.SObject";
	
	seasar.lang.SObject.defineClass = function(className, superClass, propertyNames,
			constructorFunc) {
				
		var clazz = this.defineClazz(className, constructorFunc);
		this.setSuperClass(clazz, superClass);
		this.defineProperties(clazz, propertyNames);
		return clazz;
	}
	
	seasar.lang.SObject.defineClazz = function(className, constructorFunc) {
		var cn_array = className.split(".");
		var num = cn_array.length - 1;
		var package = _global;
		for (var i = 0; i < num; ++i) {
			if (package[cn_array[i]] == null ) {
				package[cn_array[i]] = new Object();
			}
			package = package[cn_array[i]];
		}
		if (constructorFunc != null) {
			package[cn_array[num]] = constructorFunc;
		} else {
			package[cn_array[num]] = function() {
				super(arguments);
			}
		}
		var clazz = package[cn_array[num]];
		clazz.name = className;
		clazz.toString = this.toString;
		return clazz;
	}
	
	seasar.lang.SObject.toString = function() {
		return "class " + this.name;
	}
	
	seasar.lang.SObject.setSuperClass = function(subClass, superClass) {
		if (superClass == null) {
			superClass = seasar.lang.SObject;
		}
		subClass.prototype.__constructor__ = superClass;
		subClass.prototype.__proto__ = superClass.prototype;
		ASSetPropFlags(subClass.prototype, "__constructor__", 1);
	}
	
	seasar.lang.SObject.defineProperties = function(clazz, propertyNames) {
		if (propertyNames != null) {
			var proto = clazz.prototype;
			var propertyNameCount = propertyNames.length;
			for (var i = 0; i < propertyNameCount; ++i) {
				proto[propertyNames[i]] = null;
			}
		}
	}
	
	seasar.lang.SObject.__resolve = function(propertyName) {
		trace(this.name + "." + propertyName + " undefined");
	}
		
	var proto = seasar.lang.SObject.prototype;
	
	proto.__resolve = function(propertyName) {
		trace(this.constructor.name + "." + propertyName + " undefined");
	}
	
	proto.toString = function() {
		var s = "";
		for (var p in this) {
			var pVal = this[p];
			var pType = typeof pVal;
			if (pType != "function") {
				s += p +":"+ pVal + ", ";
			}
		}
		return s.substring(0, s.length - 2);
	}
	
	delete proto;
}