/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.unit;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.SqlDeleteTableWriter;
import org.seasar.extension.dataset.impl.SqlReloadReader;
import org.seasar.extension.dataset.impl.SqlReloadTableReader;
import org.seasar.extension.dataset.impl.SqlTableReader;
import org.seasar.extension.dataset.impl.SqlWriter;
import org.seasar.extension.dataset.impl.XlsReader;
import org.seasar.extension.dataset.impl.XlsWriter;
import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.extension.jdbc.impl.BasicUpdateHandler;
import org.seasar.extension.unit.BeanListReader;
import org.seasar.extension.unit.BeanReader;
import org.seasar.extension.unit.MapListReader;
import org.seasar.extension.unit.MapReader;
import org.seasar.framework.unit.S2FrameworkTestCase;
import org.seasar.framework.util.FileOutputStreamUtil;
import org.seasar.framework.util.ResourceUtil;

public abstract class S2TestCase
extends S2FrameworkTestCase {
    public S2TestCase() {
    }

    public S2TestCase(String name) {
        super(name);
    }

    public DataSet readXls(String path) {
        XlsReader reader = new XlsReader(this.convertPath(path));
        return reader.read();
    }

    public void writeXls(String path, DataSet dataSet) {
        File dir = ResourceUtil.getBuildDir(((Object)((Object)this)).getClass());
        File file = new File(dir, this.convertPath(path));
        XlsWriter writer = new XlsWriter(FileOutputStreamUtil.create((File)file));
        writer.write(dataSet);
    }

    public void writeDb(DataSet dataSet) {
        SqlWriter writer = new SqlWriter(this.getDataSource());
        writer.write(dataSet);
    }

    public DataTable readDbByTable(String table) {
        return this.readDbByTable(table, null);
    }

    public DataTable readDbByTable(String table, String condition) {
        SqlTableReader reader = new SqlTableReader(this.getDataSource());
        reader.setTable(table, condition);
        return reader.read();
    }

    public DataTable readDbBySql(String sql, String tableName) {
        SqlTableReader reader = new SqlTableReader(this.getDataSource());
        reader.setSql(sql, tableName);
        return reader.read();
    }

    public void readXlsWriteDb(String path) {
        this.writeDb(this.readXls(path));
    }

    public void readXlsReplaceDb(String path) {
        DataSet dataSet = this.readXls(path);
        this.deleteDb(dataSet);
        this.writeDb(dataSet);
    }

    public void readXlsAllReplaceDb(String path) {
        DataSet dataSet = this.readXls(path);
        int i = dataSet.getTableSize() - 1;
        while (i >= 0) {
            this.deleteTable(dataSet.getTable(i).getTableName());
            --i;
        }
        this.writeDb(dataSet);
    }

    public DataSet reload(DataSet dataSet) {
        return new SqlReloadReader(this.getDataSource(), dataSet).read();
    }

    public DataTable reload(DataTable table) {
        return new SqlReloadTableReader(this.getDataSource(), table).read();
    }

    public void deleteDb(DataSet dataSet) {
        SqlDeleteTableWriter writer = new SqlDeleteTableWriter(this.getDataSource());
        int i = dataSet.getTableSize() - 1;
        while (i >= 0) {
            writer.write(dataSet.getTable(i));
            --i;
        }
    }

    public void deleteTable(String tableName) {
        BasicUpdateHandler handler = new BasicUpdateHandler(this.getDataSource(), "DELETE FROM " + tableName);
        handler.execute(null);
    }

    public void assertEquals(DataSet expected, DataSet actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String message, DataSet expected, DataSet actual) {
        message = message == null ? "" : message;
        S2TestCase.assertEquals((String)(String.valueOf(message) + ":TableSize"), (int)expected.getTableSize(), (int)actual.getTableSize());
        int i = 0;
        while (i < expected.getTableSize()) {
            this.assertEquals(message, expected.getTable(i), actual.getTable(i));
            ++i;
        }
    }

    public void assertEquals(DataTable expected, DataTable actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String message, DataTable expected, DataTable actual) {
        message = message == null ? "" : message;
        message = String.valueOf(message) + ":TableName=" + expected.getTableName();
        S2TestCase.assertEquals((String)(String.valueOf(message) + ":RowSize"), (int)expected.getRowSize(), (int)actual.getRowSize());
        int i = 0;
        while (i < expected.getRowSize()) {
            DataRow expectedRow = expected.getRow(i);
            DataRow actualRow = actual.getRow(i);
            ArrayList<String> errorMessages = new ArrayList<String>();
            int j = 0;
            while (j < expected.getColumnSize()) {
                try {
                    String columnName = expected.getColumnName(j);
                    Object expectedValue = expectedRow.getValue(columnName);
                    ColumnType ct = ColumnTypes.getColumnType(expectedValue);
                    Object actualValue = actualRow.getValue(columnName);
                    if (!ct.equals(expectedValue, actualValue)) {
                        S2TestCase.assertEquals((String)(String.valueOf(message) + ":Row=" + i + ":columnName=" + columnName), (Object)expectedValue, (Object)actualValue);
                    }
                }
                catch (AssertionFailedError e) {
                    errorMessages.add(e.getMessage());
                }
                ++j;
            }
            if (!errorMessages.isEmpty()) {
                S2TestCase.fail((String)(String.valueOf(message) + errorMessages));
            }
            ++i;
        }
    }

    public void assertEquals(DataSet expected, Object actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String message, DataSet expected, Object actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
            return;
        }
        if (actual instanceof List) {
            List actualList = (List)actual;
            Assert.assertFalse((boolean)actualList.isEmpty());
            Object actualItem = actualList.get(0);
            if (actualItem instanceof Map) {
                this.assertMapListEquals(message, expected, actualList);
            } else {
                this.assertBeanListEquals(message, expected, actualList);
            }
        } else if (actual instanceof Object[]) {
            this.assertEquals(message, expected, Arrays.asList((Object[])actual));
        } else if (actual instanceof Map) {
            this.assertMapEquals(message, expected, (Map)actual);
        } else {
            this.assertBeanEquals(message, expected, actual);
        }
    }

    protected void assertMapEquals(String message, DataSet expected, Map map) {
        MapReader reader = new MapReader(map);
        this.assertEquals(message, expected, reader.read());
    }

    protected void assertMapListEquals(String message, DataSet expected, List list) {
        MapListReader reader = new MapListReader(list);
        this.assertEquals(message, expected, reader.read());
    }

    protected void assertBeanEquals(String message, DataSet expected, Object bean) {
        BeanReader reader = new BeanReader(bean);
        this.assertEquals(message, expected, reader.read());
    }

    protected void assertBeanListEquals(String message, DataSet expected, List list) {
        BeanListReader reader = new BeanListReader(list);
        this.assertEquals(message, expected, reader.read());
    }
}

