/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.catalina.ssi.SSICommand;
import org.apache.catalina.ssi.SSIInclude;
import org.apache.catalina.ssi.SSIMediator;
import org.apache.catalina.util.IOTools;

public class SSIExec
implements SSICommand {
    protected SSIInclude ssiInclude = new SSIInclude();
    protected static final int BUFFER_SIZE = 1024;

    public void process(SSIMediator ssiMediator, String[] paramNames, String[] paramValues, PrintWriter writer) {
        String configErrMsg = ssiMediator.getConfigErrMsg();
        String paramName = paramNames[0];
        String paramValue = paramValues[0];
        if (paramName.equalsIgnoreCase("cgi")) {
            this.ssiInclude.process(ssiMediator, new String[]{"virtual"}, new String[]{paramValue}, writer);
        } else if (paramName.equalsIgnoreCase("cmd")) {
            boolean foundProgram = false;
            try {
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec(paramValue);
                foundProgram = true;
                BufferedReader stdOutReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                BufferedReader stdErrReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                char[] buf = new char[1024];
                IOTools.flow((Reader)stdErrReader, (Writer)writer, (char[])buf);
                IOTools.flow((Reader)stdOutReader, (Writer)writer, (char[])buf);
                proc.waitFor();
            }
            catch (InterruptedException e) {
                ssiMediator.log("Couldn't exec file: " + paramValue, e);
                writer.write(configErrMsg);
            }
            catch (IOException e) {
                if (!foundProgram) {
                    // empty if block
                }
                ssiMediator.log("Couldn't exec file: " + paramValue, e);
            }
        }
    }
}

