/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.framework.mock.servlet.MockHttpServletResponseImpl;
import org.seasar.framework.mock.servlet.MockServlet;
import org.seasar.framework.mock.servlet.MockServletConfig;
import org.seasar.framework.mock.servlet.MockServletConfigImpl;
import org.seasar.framework.mock.servlet.MockServletContext;
import org.seasar.framework.mock.servlet.MockServletContextImpl;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public abstract class S2FrameworkTestCase
extends TestCase {
    private static final String DATASOURCE_NAME = "j2ee.dataSource";
    private S2Container container_;
    private Servlet servlet_;
    private MockServletConfig servletConfig_;
    private MockServletContext servletContext_;
    private MockHttpServletRequest request_;
    private MockHttpServletResponse response_;
    private DataSource dataSource_;
    private Connection connection_;
    private DatabaseMetaData dbMetaData_;
    private List bindedFields_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public S2FrameworkTestCase() {
    }

    public S2FrameworkTestCase(String name) {
        super(name);
    }

    public S2Container getContainer() {
        return this.container_;
    }

    public Object getComponent(String componentName) {
        return this.container_.getComponent(componentName);
    }

    public Object getComponent(Class componentClass) {
        return this.container_.getComponent(componentClass);
    }

    public ComponentDef getComponentDef(String componentName) {
        return this.container_.getComponentDef(componentName);
    }

    public ComponentDef getComponentDef(Class componentClass) {
        return this.container_.getComponentDef(componentClass);
    }

    public void register(Class componentClass) {
        this.container_.register(componentClass);
    }

    public void register(Class componentClass, String componentName) {
        this.container_.register(componentClass, componentName);
    }

    public void register(Object component) {
        this.container_.register(component);
    }

    public void register(Object component, String componentName) {
        this.container_.register(component, componentName);
    }

    public void register(ComponentDef componentDef) {
        this.container_.register(componentDef);
    }

    public void include(String path) {
        S2ContainerFactory.include(this.container_, this.convertPath(path));
    }

    protected String convertPath(String path) {
        if (ResourceUtil.getResourceNoException(path) != null) {
            return path;
        }
        String prefix = ((Object)((Object)this)).getClass().getName().replace('.', '/').replaceFirst("/[^/]+$", "");
        return String.valueOf(prefix) + "/" + path;
    }

    public DataSource getDataSource() {
        if (this.dataSource_ == null) {
            throw new EmptyRuntimeException("dataSource");
        }
        return this.dataSource_;
    }

    public Connection getConnection() {
        if (this.connection_ != null) {
            return this.connection_;
        }
        this.connection_ = DataSourceUtil.getConnection(this.getDataSource());
        return this.connection_;
    }

    public DatabaseMetaData getDatabaseMetaData() {
        if (this.dbMetaData_ != null) {
            return this.dbMetaData_;
        }
        this.dbMetaData_ = ConnectionUtil.getMetaData(this.getConnection());
        return this.dbMetaData_;
    }

    /*
     * Unable to fully structure code
     */
    public void runBare() throws Throwable {
        this.setUpContainer();
        this.setUp();
        try {
            this.setUpForEachTestMethod();
            try {
                this.container_.init();
                try {
                    this.setupDataSource();
                    try {
                        this.setUpAfterContainerInit();
                        this.bindFields();
                        this.setUpAfterBindFields();
                        try {
                            this.runTestTx();
                        }
                        finally {
                            this.tearDownBeforeUnbindFields();
                            this.unbindFields();
                        }
                        this.tearDownBeforeContainerDestroy();
                    }
                    finally {
                        this.tearDownDataSource();
                    }
                }
                finally {
                    this.tearDownContainer();
                }
            }
            catch (Throwable var4_4) {
                this.tearDownForEachTestMethod();
                throw var4_4;
            }
            this.tearDownForEachTestMethod();
        }
        finally {
            i = 0;
            ** while (i < 5)
        }
lbl-1000:
        // 1 sources

        {
            System.runFinalization();
            System.gc();
            ++i;
            continue;
        }
lbl42:
        // 1 sources

        this.tearDown();
    }

    protected void setUpContainer() throws Throwable {
        this.container_ = new S2ContainerImpl();
        this.servletContext_ = new MockServletContextImpl("s2jsf-example");
        this.request_ = this.servletContext_.createRequest("/hello.html");
        this.response_ = new MockHttpServletResponseImpl(this.request_);
        this.servletConfig_ = new MockServletConfigImpl();
        this.servletConfig_.setServletContext(this.servletContext_);
        this.servlet_ = new MockServlet();
        this.servlet_.init((ServletConfig)this.servletConfig_);
        this.container_.setServletContext(this.servletContext_);
        this.container_.setRequest(this.request_);
        this.container_.setResponse(this.response_);
        SingletonS2ContainerFactory.setContainer(this.container_);
    }

    protected void tearDownContainer() throws Throwable {
        this.container_.destroy();
        SingletonS2ContainerFactory.setContainer(null);
        this.container_ = null;
        this.servletContext_ = null;
        this.request_ = null;
        this.response_ = null;
        this.servletConfig_ = null;
        this.servlet_ = null;
    }

    protected void setUpAfterContainerInit() throws Throwable {
    }

    protected void setUpAfterBindFields() throws Throwable {
    }

    protected void tearDownBeforeUnbindFields() throws Throwable {
    }

    protected void setUpForEachTestMethod() throws Throwable {
        String targetName = this.getTargetName();
        if (targetName.length() > 0) {
            this.invoke("setUp" + targetName);
        }
    }

    protected void tearDownBeforeContainerDestroy() throws Throwable {
    }

    protected void tearDownForEachTestMethod() throws Throwable {
        String targetName = this.getTargetName();
        if (targetName.length() > 0) {
            this.invoke("tearDown" + this.getTargetName());
        }
    }

    protected Servlet getServlet() {
        return this.servlet_;
    }

    protected void setServlet(Servlet servlet) {
        this.servlet_ = servlet;
    }

    protected MockServletConfig getServletConfig() {
        return this.servletConfig_;
    }

    protected void setServletConfig(MockServletConfig servletConfig) {
        this.servletConfig_ = servletConfig;
    }

    protected MockServletContext getServletContext() {
        return this.servletContext_;
    }

    protected void setServletContext(MockServletContext servletContext) {
        this.servletContext_ = servletContext;
    }

    protected MockHttpServletRequest getRequest() {
        return this.request_;
    }

    protected void setRequest(MockHttpServletRequest request) {
        this.request_ = request;
    }

    protected MockHttpServletResponse getResponse() {
        return this.response_;
    }

    protected void setResponse(MockHttpServletResponse response) {
        this.response_ = response;
    }

    protected String getTargetName() {
        return this.getName().substring(4);
    }

    protected void invoke(String methodName) throws Throwable {
        try {
            Method method = ClassUtil.getMethod(((Object)((Object)this)).getClass(), methodName, null);
            MethodUtil.invoke(method, (Object)this, null);
        }
        catch (NoSuchMethodRuntimeException noSuchMethodRuntimeException) {
            // empty catch block
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void bindFields() throws Throwable {
        Class<?> clazz;
        this.bindedFields_ = new ArrayList();
        Class<?> clazz2 = ((Object)((Object)this)).getClass();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                Field[] fields = clazz2.getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    this.bindField(fields[i]);
                    ++i;
                }
                clazz2 = clazz2.getSuperclass();
            }
            if ((clazz = class$0) != null) continue;
            try {
                clazz = Class.forName("org.seasar.framework.unit.S2FrameworkTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz2 != clazz && clazz2 != null);
    }

    protected void bindField(Field field) {
        if (this.isAutoBindable(field)) {
            field.setAccessible(true);
            if (FieldUtil.get(field, (Object)this) != null) {
                return;
            }
            String name = this.normalizeName(field.getName());
            Object component = null;
            if (this.getContainer().hasComponentDef(name)) {
                Class<?> componentClass = this.getComponentDef(name).getComponentClass();
                if (componentClass == null && (component = this.getComponent(name)) != null) {
                    componentClass = component.getClass();
                }
                if (componentClass != null && field.getType().isAssignableFrom(componentClass)) {
                    if (component == null) {
                        component = this.getComponent(name);
                    }
                } else {
                    component = null;
                }
            }
            if (component == null && this.getContainer().hasComponentDef(field.getType())) {
                component = this.getComponent(field.getType());
            }
            if (component != null) {
                FieldUtil.set(field, (Object)this, component);
                this.bindedFields_.add(field);
            }
        }
    }

    protected String normalizeName(String name) {
        return StringUtil.replace(name, "_", "");
    }

    protected boolean isAutoBindable(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && !field.getType().isPrimitive();
    }

    protected void unbindFields() {
        int i = 0;
        while (i < this.bindedFields_.size()) {
            Field field = (Field)this.bindedFields_.get(i);
            try {
                field.set((Object)this, null);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e);
            }
            catch (IllegalAccessException e) {
                System.err.println(e);
            }
            ++i;
        }
    }

    protected void runTestTx() throws Throwable {
        TransactionManager tm = null;
        if (this.needTransaction()) {
            try {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("javax.transaction.TransactionManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                tm = (TransactionManager)this.getComponent(clazz);
                tm.begin();
            }
            catch (Throwable t) {
                System.err.println(t);
            }
        }
        try {
            this.runTest();
        }
        finally {
            if (tm != null) {
                tm.rollback();
            }
        }
    }

    protected boolean needTransaction() {
        return this.getName().endsWith("Tx");
    }

    protected void setupDataSource() {
        block9: {
            try {
                if (this.container_.hasComponentDef(DATASOURCE_NAME)) {
                    this.dataSource_ = (DataSource)this.container_.getComponent(DATASOURCE_NAME);
                    break block9;
                }
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("javax.sql.DataSource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!this.container_.hasComponentDef(clazz)) break block9;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("javax.sql.DataSource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.dataSource_ = (DataSource)this.container_.getComponent(clazz2);
            }
            catch (Throwable t) {
                System.err.println(t);
            }
        }
    }

    protected void tearDownDataSource() {
        this.dbMetaData_ = null;
        if (this.connection_ != null) {
            ConnectionUtil.close(this.connection_);
            this.connection_ = null;
        }
        this.dataSource_ = null;
    }
}

