/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.mock.servlet;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionContext;
import org.seasar.framework.mock.servlet.MockHttpSession;
import org.seasar.framework.util.EnumerationAdapter;

public class MockHttpSessionImpl
implements MockHttpSession,
Serializable {
    private static final long serialVersionUID = 2182279632419560836L;
    private final long creationTime_;
    private long lastAccessedTime_;
    private ServletContext servletContext_;
    private String id_;
    private boolean new_;
    private boolean valid_;
    private int maxInactiveInterval_;
    private Map attributes_;

    public MockHttpSessionImpl(ServletContext servletContext) {
        this.lastAccessedTime_ = this.creationTime_ = System.currentTimeMillis();
        this.new_ = true;
        this.valid_ = true;
        this.maxInactiveInterval_ = -1;
        this.attributes_ = new HashMap();
        this.servletContext_ = servletContext;
        this.id_ = "id/" + this.hashCode();
    }

    public long getCreationTime() {
        return this.creationTime_;
    }

    public String getId() {
        return this.id_;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime_;
    }

    public void access() {
        this.new_ = false;
        this.lastAccessedTime_ = System.currentTimeMillis();
    }

    public ServletContext getServletContext() {
        return this.servletContext_;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval_ = maxInactiveInterval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval_;
    }

    public Object getAttribute(String name) {
        return this.attributes_.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes_.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes_.remove(name);
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return new EnumerationAdapter(this.attributes_.keySet().iterator());
    }

    public String[] getValueNames() {
        return this.attributes_.keySet().toArray(new String[this.attributes_.size()]);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        if (!this.valid_) {
            return;
        }
        this.attributes_.clear();
        this.valid_ = false;
    }

    public boolean isNew() {
        return this.new_;
    }

    public boolean isValid() {
        return this.valid_;
    }

    public void setValid(boolean valid) {
        this.valid_ = valid;
    }
}

