/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.impl;

import org.seasar.framework.beans.PropertyNotFoundRuntimeException;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.AutoBindingDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentDeployer;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.assembler.AutoBindingDefFactory;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.util.AopProxyUtil;
import org.seasar.framework.container.util.ArgDefSupport;
import org.seasar.framework.container.util.AspectDefSupport;
import org.seasar.framework.container.util.DestroyMethodDefSupport;
import org.seasar.framework.container.util.InitMethodDefSupport;
import org.seasar.framework.container.util.MetaDefSupport;
import org.seasar.framework.container.util.PropertyDefSupport;
import org.seasar.framework.hotswap.Hotswap;

public class ComponentDefImpl
implements ComponentDef,
ContainerConstants {
    private Class componentClass_;
    private String componentName_;
    private Class concreteClass_;
    private S2Container container_;
    private String expression_;
    private ArgDefSupport argDefSupport_ = new ArgDefSupport();
    private PropertyDefSupport propertyDefSupport_ = new PropertyDefSupport();
    private InitMethodDefSupport initMethodDefSupport_ = new InitMethodDefSupport();
    private DestroyMethodDefSupport destroyMethodDefSupport_ = new DestroyMethodDefSupport();
    private AspectDefSupport aspectDefSupport_ = new AspectDefSupport();
    private MetaDefSupport metaDefSupport_ = new MetaDefSupport();
    private InstanceDef instanceDef_ = InstanceDefFactory.SINGLETON;
    private AutoBindingDef autoBindingDef_ = AutoBindingDefFactory.AUTO;
    private ComponentDeployer componentDeployer_;
    private Hotswap hotswap_;

    public ComponentDefImpl() {
    }

    public ComponentDefImpl(Class componentClass) {
        this(componentClass, null);
    }

    public ComponentDefImpl(Class componentClass, String componentName) {
        this.componentClass_ = componentClass;
        this.componentName_ = componentName;
    }

    public Object getComponent() {
        return this.getComponentDeployer().deploy();
    }

    public void injectDependency(Object outerComponent) {
        this.getComponentDeployer().injectDependency(outerComponent);
    }

    public final Class getComponentClass() {
        this.updateComponentClass();
        return this.componentClass_;
    }

    protected synchronized void updateComponentClass() {
        if (this.hotswap_ != null && this.hotswap_.isModified()) {
            this.componentClass_ = this.hotswap_.updateTargetClass();
            this.concreteClass_ = null;
        }
    }

    public final String getComponentName() {
        return this.componentName_;
    }

    public void setComponentName(String componentName) {
        this.componentName_ = componentName;
    }

    public final synchronized Class getConcreteClass() {
        this.updateComponentClass();
        if (this.concreteClass_ == null) {
            this.concreteClass_ = AopProxyUtil.getConcreteClass(this);
        }
        return this.concreteClass_;
    }

    public final S2Container getContainer() {
        return this.container_;
    }

    public final void setContainer(S2Container container) {
        this.container_ = container;
        this.argDefSupport_.setContainer(container);
        this.metaDefSupport_.setContainer(container);
        this.propertyDefSupport_.setContainer(container);
        this.initMethodDefSupport_.setContainer(container);
        this.destroyMethodDefSupport_.setContainer(container);
        this.aspectDefSupport_.setContainer(container);
    }

    public void addArgDef(ArgDef argDef) {
        this.argDefSupport_.addArgDef(argDef);
    }

    public void addPropertyDef(PropertyDef propertyDef) {
        this.propertyDefSupport_.addPropertyDef(propertyDef);
    }

    public void addInitMethodDef(InitMethodDef methodDef) {
        this.initMethodDefSupport_.addInitMethodDef(methodDef);
    }

    public void addDestroyMethodDef(DestroyMethodDef methodDef) {
        this.destroyMethodDefSupport_.addDestroyMethodDef(methodDef);
    }

    public synchronized void addAspectDef(AspectDef aspectDef) {
        this.aspectDefSupport_.addAspectDef(aspectDef);
        this.concreteClass_ = null;
    }

    public int getArgDefSize() {
        return this.argDefSupport_.getArgDefSize();
    }

    public int getPropertyDefSize() {
        return this.propertyDefSupport_.getPropertyDefSize();
    }

    public int getInitMethodDefSize() {
        return this.initMethodDefSupport_.getInitMethodDefSize();
    }

    public int getDestroyMethodDefSize() {
        return this.destroyMethodDefSupport_.getDestroyMethodDefSize();
    }

    public int getAspectDefSize() {
        return this.aspectDefSupport_.getAspectDefSize();
    }

    public InstanceDef getInstanceDef() {
        return this.instanceDef_;
    }

    public void setInstanceDef(InstanceDef instanceDef) {
        this.instanceDef_ = instanceDef;
    }

    public AutoBindingDef getAutoBindingDef() {
        return this.autoBindingDef_;
    }

    public void setAutoBindingDef(AutoBindingDef autoBindingDef) {
        this.autoBindingDef_ = autoBindingDef;
    }

    public void init() {
        if (this.hotswap_ == null && this.componentClass_ != null && this.container_ != null && this.container_.getRoot().isHotswapMode()) {
            this.hotswap_ = new Hotswap(this.componentClass_);
        }
        this.getComponentDeployer().init();
    }

    public void destroy() {
        this.getComponentDeployer().destroy();
    }

    public String getExpression() {
        return this.expression_;
    }

    public void setExpression(String expression) {
        this.expression_ = expression;
    }

    public ArgDef getArgDef(int index) {
        return this.argDefSupport_.getArgDef(index);
    }

    public PropertyDef getPropertyDef(int index) {
        return this.propertyDefSupport_.getPropertyDef(index);
    }

    public PropertyDef getPropertyDef(String propertyName) {
        if (this.hasPropertyDef(propertyName)) {
            return this.propertyDefSupport_.getPropertyDef(propertyName);
        }
        throw new PropertyNotFoundRuntimeException(this.componentClass_, propertyName);
    }

    public boolean hasPropertyDef(String propertyName) {
        return this.propertyDefSupport_.hasPropertyDef(propertyName);
    }

    public InitMethodDef getInitMethodDef(int index) {
        return this.initMethodDefSupport_.getInitMethodDef(index);
    }

    public DestroyMethodDef getDestroyMethodDef(int index) {
        return this.destroyMethodDefSupport_.getDestroyMethodDef(index);
    }

    public AspectDef getAspectDef(int index) {
        return this.aspectDefSupport_.getAspectDef(index);
    }

    public void addMetaDef(MetaDef metaDef) {
        this.metaDefSupport_.addMetaDef(metaDef);
    }

    public MetaDef getMetaDef(int index) {
        return this.metaDefSupport_.getMetaDef(index);
    }

    public MetaDef getMetaDef(String name) {
        return this.metaDefSupport_.getMetaDef(name);
    }

    public MetaDef[] getMetaDefs(String name) {
        return this.metaDefSupport_.getMetaDefs(name);
    }

    public int getMetaDefSize() {
        return this.metaDefSupport_.getMetaDefSize();
    }

    public Hotswap getHotswap() {
        return this.hotswap_;
    }

    public synchronized ComponentDeployer getComponentDeployer() {
        if (this.componentDeployer_ == null) {
            this.componentDeployer_ = this.instanceDef_.createComponentDeployer(this);
        }
        return this.componentDeployer_;
    }
}

