/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.CyclicReferenceRuntimeException;
import org.seasar.framework.container.deployer.AbstractComponentDeployer;
import org.seasar.framework.hotswap.Hotswap;
import org.seasar.framework.hotswap.HotswapProxy;
import org.seasar.framework.hotswap.HotswapTargetFactory;

public class SingletonComponentDeployer
extends AbstractComponentDeployer
implements HotswapTargetFactory {
    private Object component_;
    private Object hotswapTarget_;
    private Hotswap hotswap_;
    private boolean instantiating_ = false;

    public SingletonComponentDeployer(ComponentDef componentDef) {
        super(componentDef);
    }

    public synchronized Object deploy() {
        if (this.component_ == null) {
            this.assemble();
        }
        return this.component_;
    }

    public void injectDependency(Object component) {
        throw new UnsupportedOperationException("injectDependency");
    }

    private void assemble() {
        if (this.instantiating_) {
            throw new CyclicReferenceRuntimeException(this.getComponentDef().getComponentClass());
        }
        this.instantiating_ = true;
        try {
            Object o = this.getConstructorAssembler().assemble();
            if (this.hotswap_ != null) {
                this.hotswapTarget_ = o;
                if (this.component_ == null) {
                    this.component_ = HotswapProxy.create(this.getComponentDef().getComponentClass(), this, Thread.currentThread().getContextClassLoader());
                }
            } else {
                this.component_ = o;
            }
        }
        finally {
            this.instantiating_ = false;
        }
        this.getPropertyAssembler().assemble(this.getTarget());
        this.getInitMethodAssembler().assemble(this.getTarget());
    }

    protected Object getTarget() {
        return this.hotswapTarget_ != null ? this.hotswapTarget_ : this.component_;
    }

    public void init() {
        this.hotswap_ = this.getComponentDef().getHotswap();
        if (this.hotswap_ != null && !this.isAppliedHotswap()) {
            this.hotswap_ = null;
        }
        this.deploy();
    }

    protected boolean isAppliedHotswap() {
        Class clazz = this.getComponentDef().getComponentClass();
        if (clazz == null) {
            return false;
        }
        Class<?>[] itfs = clazz.getInterfaces();
        if (itfs == null) {
            return false;
        }
        int i = 0;
        while (i < itfs.length) {
            if (itfs[i].getMethods().length > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void destroy() {
        if (this.component_ == null) {
            return;
        }
        this.getDestroyMethodAssembler().assemble(this.getTarget());
        this.component_ = null;
        this.hotswapTarget_ = null;
    }

    public synchronized Object updateTarget() {
        if (this.hotswap_.isModified()) {
            this.assemble();
        }
        return this.hotswapTarget_;
    }
}

