/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.seasar.framework.container.autoregister.AbstractComponentAutoRegister;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.ResourceUtil;

public class ComponentAutoRegister
extends AbstractComponentAutoRegister
implements ClassTraversal.ClassHandler {
    private List referenceClasses = new ArrayList();
    private Map strategies = new HashMap();

    public ComponentAutoRegister() {
        this.strategies.put("file", new FileSystemStrategy());
        this.strategies.put("jar", new JarFileStrategy());
    }

    public void addReferenceClass(Class referenceClass) {
        this.referenceClasses.add(referenceClass);
    }

    public void registAll() {
        int i = 0;
        while (i < this.referenceClasses.size()) {
            Class referenceClass = (Class)this.referenceClasses.get(i);
            String baseClassPath = ResourceUtil.getResourcePath(referenceClass);
            URL url = ResourceUtil.getResource(baseClassPath);
            Strategy strategy = (Strategy)this.strategies.get(url.getProtocol());
            strategy.registAll(referenceClass, url);
            ++i;
        }
    }

    private static interface Strategy {
        public void registAll(Class var1, URL var2);
    }

    private class FileSystemStrategy
    implements Strategy {
        FileSystemStrategy() {
        }

        public void registAll(Class referenceClass, URL url) {
            File rootDir = this.getRootDir(referenceClass, url);
            int i = 0;
            while (i < ComponentAutoRegister.this.getClassPatternSize()) {
                ClassTraversal.forEach(rootDir, ComponentAutoRegister.this.getClassPattern(i).getPackageName(), ComponentAutoRegister.this);
                ++i;
            }
        }

        protected File getRootDir(Class referenceClass, URL url) {
            String[] names = referenceClass.getName().split("\\.");
            File path = ResourceUtil.getFile(url);
            int i = 0;
            while (i < names.length) {
                path = path.getParentFile();
                ++i;
            }
            return path;
        }
    }

    private class JarFileStrategy
    implements Strategy {
        JarFileStrategy() {
        }

        public void registAll(Class referenceClass, URL url) {
            JarFile jarFile = this.createJarFile(url);
            ClassTraversal.forEach(jarFile, (ClassTraversal.ClassHandler)ComponentAutoRegister.this);
        }

        private JarFile createJarFile(URL url) {
            String urlString = ResourceUtil.toExternalForm(url);
            int pos = urlString.lastIndexOf(33);
            String jarFileName = urlString.substring(9, pos);
            return JarFileUtil.create(new File(jarFileName));
        }
    }
}

