/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.framework.container.autoregister.AutoNaming;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;

public abstract class AbstractAutoNaming
implements AutoNaming {
    protected static final String IMPL = "Impl";
    protected static final String BEAN = "Bean";
    protected boolean decapitalize = true;
    protected Map customizedNames = new HashMap();
    protected Map replaceRules = new LinkedHashMap();

    public AbstractAutoNaming() {
        this.addIgnoreClassSuffix(IMPL);
        this.addIgnoreClassSuffix(BEAN);
    }

    public void setCustomizedName(String fqcn, String name) {
        this.customizedNames.put(fqcn, name);
    }

    public void addIgnoreClassSuffix(String classSuffix) {
        this.addReplaceRule(String.valueOf(classSuffix) + "$", "");
    }

    public void addReplaceRule(String regex, String replacement) {
        this.replaceRules.put(Pattern.compile(regex), replacement);
    }

    public void clearReplaceRule() {
        this.customizedNames.clear();
        this.replaceRules.clear();
    }

    public void setDecapitalize(boolean decapitalize) {
        this.decapitalize = decapitalize;
    }

    public String defineName(String packageName, String shortClassName) {
        String customizedName = this.getCustomizedName(packageName, shortClassName);
        if (customizedName != null) {
            return customizedName;
        }
        return this.makeDefineName(packageName, shortClassName);
    }

    protected String getCustomizedName(String packageName, String shortClassName) {
        String fqn = ClassUtil.concatName(packageName, shortClassName);
        return (String)this.customizedNames.get(fqn);
    }

    protected abstract String makeDefineName(String var1, String var2);

    protected String applyRule(String name) {
        Iterator it = this.replaceRules.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Pattern pattern = (Pattern)entry.getKey();
            String replacement = (String)entry.getValue();
            Matcher matcher = pattern.matcher(name);
            name = matcher.replaceAll(replacement);
        }
        name = this.normalize(name);
        if (this.decapitalize) {
            name = StringUtil.decapitalize(name);
        }
        return name;
    }

    protected String normalize(String name) {
        String[] names = name.split("\\.");
        StringBuffer buf = new StringBuffer(name.length());
        int i = 0;
        while (i < names.length) {
            buf.append(StringUtil.capitalize(names[i]));
            ++i;
        }
        return new String(buf);
    }
}

