/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ConstructorAssembler;
import org.seasar.framework.container.MethodAssembler;
import org.seasar.framework.container.PropertyAssembler;
import org.seasar.framework.container.assembler.AutoConstructorAssembler;
import org.seasar.framework.container.assembler.AutoPropertyAssembler;
import org.seasar.framework.container.assembler.DefaultConstructorConstructorAssembler;
import org.seasar.framework.container.assembler.DefaultDestroyMethodAssembler;
import org.seasar.framework.container.assembler.DefaultInitMethodAssembler;
import org.seasar.framework.container.assembler.ManualOnlyPropertyAssembler;

public class AssemblerFactory {
    private static Provider provider_ = new DefaultProvider();

    public static Provider getProvider() {
        return provider_;
    }

    public static void setProvider(Provider provider) {
        provider_ = provider;
    }

    public static MethodAssembler createInitMethodAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createInitMethodAssembler(cd);
    }

    public static MethodAssembler createDestroyMethodAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createDestroyMethodAssembler(cd);
    }

    public static ConstructorAssembler createAutoConstructorAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createAutoConstructorAssembler(cd);
    }

    public static ConstructorAssembler createDefaultConstructorConstructorAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createDefaultConstructorConstructorAssembler(cd);
    }

    public static PropertyAssembler createAutoPropertyAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createAutoPropertyAssembler(cd);
    }

    public static PropertyAssembler createManualOnlyPropertyAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createManualOnlyPropertyAssembler(cd);
    }

    public static interface Provider {
        public MethodAssembler createInitMethodAssembler(ComponentDef var1);

        public MethodAssembler createDestroyMethodAssembler(ComponentDef var1);

        public ConstructorAssembler createAutoConstructorAssembler(ComponentDef var1);

        public ConstructorAssembler createDefaultConstructorConstructorAssembler(ComponentDef var1);

        public PropertyAssembler createAutoPropertyAssembler(ComponentDef var1);

        public PropertyAssembler createManualOnlyPropertyAssembler(ComponentDef var1);
    }

    public static class DefaultProvider
    implements Provider {
        public MethodAssembler createInitMethodAssembler(ComponentDef cd) {
            return new DefaultInitMethodAssembler(cd);
        }

        public MethodAssembler createDestroyMethodAssembler(ComponentDef cd) {
            return new DefaultDestroyMethodAssembler(cd);
        }

        public ConstructorAssembler createAutoConstructorAssembler(ComponentDef cd) {
            return new AutoConstructorAssembler(cd);
        }

        public ConstructorAssembler createDefaultConstructorConstructorAssembler(ComponentDef cd) {
            return new DefaultConstructorConstructorAssembler(cd);
        }

        public PropertyAssembler createAutoPropertyAssembler(ComponentDef cd) {
            return new AutoPropertyAssembler(cd);
        }

        public PropertyAssembler createManualOnlyPropertyAssembler(ComponentDef cd) {
            return new ManualOnlyPropertyAssembler(cd);
        }
    }
}

