package org.seasar.jsf.component;

import java.io.IOException;

import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.context.FacesContext;

import org.seasar.framework.util.StringUtil;

/**
 * @author higa
 *
 */
public class S2UISelectItem extends UISelectItem {

	public S2UISelectItem() {
	}
	
	/**
	 * @see javax.faces.component.UIComponent#getRendersChildren()
	 */
	public boolean getRendersChildren() {
		return true;
	}

	/**
	 * @see javax.faces.component.UISelectItem#getItemLabel()
	 */
	public String getItemLabel() {
		String s = super.getItemLabel();
		if (!StringUtil.isEmpty(s)) {
			return s;
		}
		StringBuffer buf = new StringBuffer();
		for (int i = 0; i < getChildCount(); ++i) {
			UIComponent child = (UIComponent) getChildren().get(i);
			if (child instanceof UIText) {
				String value = ((UIText) child).getValue();
				if (value != null) {
					value = value.trim();
					if (value.length() > 0) {
						buf.append(value);
					}
				}
			}
		}
		return buf.toString();
	}
	
	/**
	 * @see javax.faces.component.UIComponent#encodeChildren(javax.faces.context.FacesContext)
	 */
	public void encodeChildren(FacesContext context) throws IOException {
	}
}
