/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.util;

import java.lang.reflect.Field;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.jsf.util.BindingUtil;

public class InvokeUtil {
    private static final String EXPORT_SUFFIX = "_EXPORT";
    private static final String ACTION_BINDING_SUFFIX = "_ACTION_BINDING";
    private static final String VALUE = "value";
    private static final String BINDING_TYPE = "bindingType";
    private static final String NONE = "none";
    private static final String SESSION = "session";

    private InvokeUtil() {
    }

    public static String invoke(MethodBinding mb, FacesContext context) {
        String fromAction = mb.getExpressionString();
        String componentName = InvokeUtil.getComponentName(fromAction);
        S2Container container = SingletonS2ContainerFactory.getContainer();
        Object component = null;
        BeanDesc beanDesc = null;
        if (componentName != null && container.hasComponentDef((Object)componentName)) {
            ComponentDef cd = container.getComponentDef((Object)componentName);
            component = cd.getComponent();
            beanDesc = BeanDescFactory.getBeanDesc((Class)cd.getComponentClass());
        }
        if (component != null) {
            InvokeUtil.importVariables(component, container, beanDesc);
        }
        String outcome = InvokeUtil.invokeInternal(mb, context);
        if (component != null) {
            InvokeUtil.exportVariables(component, container, beanDesc);
        }
        return outcome;
    }

    private static String getComponentName(String fromAction) {
        if (fromAction == null) {
            return null;
        }
        int index = fromAction.indexOf(46);
        if (index > 0) {
            return fromAction.substring(2, index);
        }
        return null;
    }

    private static String invokeInternal(MethodBinding mb, FacesContext context) {
        try {
            return (String)mb.invoke(context, null);
        }
        catch (EvaluationException ex) {
            Throwable cause = ex.getCause();
            if (cause != null && cause instanceof AbortProcessingException) {
                throw (AbortProcessingException)cause;
            }
            throw ex;
        }
    }

    private static void importVariables(Object component, S2Container container, BeanDesc beanDesc) {
        int i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            block10: {
                Object var;
                String varName;
                PropertyDesc pd;
                block11: {
                    String[] array;
                    String bindingStr;
                    block12: {
                        pd = beanDesc.getPropertyDesc(i);
                        if (!pd.hasWriteMethod()) break block10;
                        varName = pd.getPropertyName();
                        String fieldName = String.valueOf(pd.getPropertyName()) + ACTION_BINDING_SUFFIX;
                        if (!beanDesc.hasField(fieldName) || (bindingStr = (String)beanDesc.getFieldValue(fieldName, null)) == null) break block11;
                        array = StringUtil.split((String)bindingStr, (String)"=, ");
                        if (array.length != 1) break block12;
                        varName = array[0];
                        break block11;
                    }
                    boolean nobinding = false;
                    int j = 0;
                    while (j < array.length) {
                        String k = array[j].trim();
                        String v = array[j + 1].trim();
                        if (BINDING_TYPE.equalsIgnoreCase(k)) {
                            nobinding = NONE.equalsIgnoreCase(v);
                        } else if (VALUE.equalsIgnoreCase(k)) {
                            varName = v;
                        } else {
                            throw new IllegalArgumentException(bindingStr);
                        }
                        j += 2;
                    }
                    if (nobinding) break block10;
                }
                if (!container.hasComponentDef((Object)varName) && (var = BindingUtil.getValue(container.getRequest(), varName)) != null) {
                    pd.setValue(component, var);
                }
            }
            ++i;
        }
    }

    private static void exportVariables(Object component, S2Container container, BeanDesc beanDesc) {
        int i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            Object var;
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (pd.hasReadMethod() && (var = pd.getValue(component)) != null) {
                boolean useSession = false;
                String fieldName = String.valueOf(pd.getPropertyName()) + EXPORT_SUFFIX;
                if (beanDesc.hasField(fieldName)) {
                    Field field = beanDesc.getField(fieldName);
                    String value = (String)FieldUtil.get((Field)field, null);
                    if (SESSION.equalsIgnoreCase(value)) {
                        useSession = true;
                    }
                } else if (container.hasComponentDef((Object)pd.getPropertyName())) {
                    ComponentDef cd = container.getComponentDef((Object)pd.getPropertyName());
                    useSession = InstanceDefFactory.SESSION.equals(cd.getInstanceDef());
                }
                if (useSession) {
                    container.getSession().setAttribute(pd.getPropertyName(), var);
                } else {
                    container.getRequest().setAttribute(pd.getPropertyName(), var);
                }
            }
            ++i;
        }
    }
}

