/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    private XmlUtils() {
    }

    public static String getElementText(Element elem) {
        StringBuffer buf = new StringBuffer();
        NodeList nodeList = elem.getChildNodes();
        int i = 0;
        int len = nodeList.getLength();
        while (i < len) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 3) {
                buf.append(n.getNodeValue());
            }
            ++i;
        }
        return buf.toString();
    }

    public static String getChildText(Element elem, String childTagName) {
        NodeList nodeList = elem.getElementsByTagName(childTagName);
        int len = nodeList.getLength();
        if (len == 0) {
            return null;
        }
        return XmlUtils.getElementText((Element)nodeList.item(len - 1));
    }

    public static List getChildTextList(Element elem, String childTagName) {
        NodeList nodeList = elem.getElementsByTagName(childTagName);
        int len = nodeList.getLength();
        if (len == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> list = new ArrayList<String>(len);
        int i = 0;
        while (i < len) {
            list.add(XmlUtils.getElementText((Element)nodeList.item(i)));
            ++i;
        }
        return list;
    }
}

