/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.calendar;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.component.html.ext.HtmlInputText;
import org.apache.myfaces.component.html.util.AddResource;
import org.apache.myfaces.custom.calendar.HtmlInputCalendar;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlRenderer;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.JavascriptUtils;

public class HtmlCalendarRenderer
extends HtmlRenderer {
    static /* synthetic */ Class class$org$apache$myfaces$custom$calendar$HtmlInputCalendar;
    static /* synthetic */ Class class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer;

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Date value;
        RendererUtils.checkParamValidity(facesContext, component, class$org$apache$myfaces$custom$calendar$HtmlInputCalendar == null ? (class$org$apache$myfaces$custom$calendar$HtmlInputCalendar = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlInputCalendar")) : class$org$apache$myfaces$custom$calendar$HtmlInputCalendar);
        HtmlInputCalendar inputCalendar = (HtmlInputCalendar)component;
        Locale currentLocale = facesContext.getViewRoot().getLocale();
        try {
            value = RendererUtils.getDateValue(inputCalendar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            value = null;
        }
        Calendar timeKeeper = Calendar.getInstance(currentLocale);
        timeKeeper.setTime(value != null ? value : new Date());
        DateFormatSymbols symbols = new DateFormatSymbols(currentLocale);
        String[] weekdays = HtmlCalendarRenderer.mapWeekdays(symbols);
        String[] months = HtmlCalendarRenderer.mapMonths(symbols);
        if (inputCalendar.isRenderAsPopup()) {
            if (inputCalendar.isAddResources()) {
                HtmlCalendarRenderer.addScriptAndCSSResources(facesContext);
            }
            String dateFormat = CalendarDateTimeConverter.createJSPopupFormat(facesContext, inputCalendar.getPopupDateFormat());
            Application application = facesContext.getApplication();
            HtmlInputText inputText = null;
            List li = inputCalendar.getChildren();
            int i = 0;
            while (i < li.size()) {
                UIComponent uiComponent = (UIComponent)li.get(i);
                if (uiComponent instanceof HtmlInputText) {
                    inputText = (HtmlInputText)uiComponent;
                    break;
                }
                ++i;
            }
            if (inputText == null) {
                inputText = (HtmlInputText)application.createComponent("org.apache.myfaces.HtmlInputText");
            }
            RendererUtils.copyHtmlInputTextAttributes(inputCalendar, inputText);
            inputText.setTransient(true);
            if (value == null && inputCalendar.getSubmittedValue() != null) {
                inputText.setValue(inputCalendar.getSubmittedValue());
            } else {
                inputText.setValue(this.getConverter(inputCalendar).getAsString(facesContext, inputCalendar, value));
            }
            inputText.setEnabledOnUserRole(inputCalendar.getEnabledOnUserRole());
            inputText.setVisibleOnUserRole(inputCalendar.getVisibleOnUserRole());
            inputCalendar.getChildren().add(inputText);
            RendererUtils.renderChild(facesContext, inputText);
            inputCalendar.getChildren().remove(inputText);
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("script", null);
            writer.writeAttribute("type", "text/javascript", null);
            writer.write("<!--\n");
            writer.writeText(HtmlCalendarRenderer.getLocalizedLanguageScript(symbols, months, timeKeeper.getFirstDayOfWeek(), inputCalendar), null);
            writer.writeText(this.getScriptBtnText(inputCalendar.getClientId(facesContext), dateFormat, inputCalendar.getPopupButtonString()), null);
            writer.write("\n-->");
            writer.endElement("script");
        } else {
            int lastDayInMonth = timeKeeper.getActualMaximum(5);
            int currentDay = timeKeeper.get(5);
            if (currentDay > lastDayInMonth) {
                currentDay = lastDayInMonth;
            }
            timeKeeper.set(5, 1);
            int weekDayOfFirstDayOfMonth = this.mapCalendarDayToCommonDay(timeKeeper.get(7));
            int weekStartsAtDayIndex = this.mapCalendarDayToCommonDay(timeKeeper.getFirstDayOfWeek());
            ResponseWriter writer = facesContext.getResponseWriter();
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("table", component);
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.UNIVERSAL_ATTRIBUTES);
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.EVENT_HANDLER_ATTRIBUTES);
            writer.flush();
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("tr", component);
            if (inputCalendar.getMonthYearRowClass() != null) {
                writer.writeAttribute("class", inputCalendar.getMonthYearRowClass(), null);
            }
            this.writeMonthYearHeader(facesContext, writer, inputCalendar, timeKeeper, currentDay, weekdays, months);
            writer.endElement("tr");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("tr", component);
            if (inputCalendar.getWeekRowClass() != null) {
                writer.writeAttribute("class", inputCalendar.getWeekRowClass(), null);
            }
            this.writeWeekDayNameHeader(weekStartsAtDayIndex, weekdays, facesContext, writer, inputCalendar);
            writer.endElement("tr");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            this.writeDays(facesContext, writer, inputCalendar, timeKeeper, currentDay, weekStartsAtDayIndex, weekDayOfFirstDayOfMonth, lastDayInMonth, weekdays);
            writer.endElement("table");
        }
    }

    public static void addScriptAndCSSResources(FacesContext facesContext) throws IOException {
        AddResource.addStyleSheet(class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer == null ? (class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlCalendarRenderer")) : class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer, "WH/theme.css", facesContext);
        AddResource.addStyleSheet(class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer == null ? (class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlCalendarRenderer")) : class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer, "DB/theme.css", facesContext);
        AddResource.addJavaScriptToHeader(class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer == null ? (class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlCalendarRenderer")) : class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer, "popcalendar.js", facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", "text/javascript", null);
        writer.write("jscalendarSetImageDirectory(\"" + JavascriptUtils.encodeString(AddResource.getResourceMappedPath(class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer == null ? (class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlCalendarRenderer")) : class$org$apache$myfaces$custom$calendar$HtmlCalendarRenderer, "DB/", facesContext)) + "\")");
        writer.endElement("script");
    }

    public static String getLocalizedLanguageScript(DateFormatSymbols symbols, String[] months, int firstDayOfWeek, HtmlInputCalendar inputCalendar) {
        String[] weekDays;
        int realFirstDayOfWeek = firstDayOfWeek - 1;
        if (realFirstDayOfWeek == 0) {
            weekDays = HtmlCalendarRenderer.mapWeekdaysStartingWithSunday(symbols);
        } else if (realFirstDayOfWeek == 1) {
            weekDays = HtmlCalendarRenderer.mapWeekdays(symbols);
        } else {
            throw new IllegalStateException("Week may only start with sunday or monday.");
        }
        StringBuffer script = new StringBuffer();
        HtmlCalendarRenderer.defineStringArray(script, "jscalendarMonthName", months);
        HtmlCalendarRenderer.defineStringArray(script, "jscalendarDayName", weekDays);
        HtmlCalendarRenderer.setIntegerVariable(script, "jscalendarStartAt", realFirstDayOfWeek);
        if (inputCalendar != null) {
            if (inputCalendar.getPopupGotoString() != null) {
                HtmlCalendarRenderer.setStringVariable(script, "jscalendarGotoString", inputCalendar.getPopupGotoString());
            }
            if (inputCalendar.getPopupTodayString() != null) {
                HtmlCalendarRenderer.setStringVariable(script, "jscalendarTodayString", inputCalendar.getPopupTodayString());
            }
            if (inputCalendar.getPopupWeekString() != null) {
                HtmlCalendarRenderer.setStringVariable(script, "jscalendarWeekString", inputCalendar.getPopupWeekString());
            }
            if (inputCalendar.getPopupScrollLeftMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, "jscalendarScrollLeftMessage", inputCalendar.getPopupScrollLeftMessage());
            }
            if (inputCalendar.getPopupScrollRightMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, "jscalendarScrollRightMessage", inputCalendar.getPopupScrollRightMessage());
            }
            if (inputCalendar.getPopupSelectMonthMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, "jscalendarSelectMonthMessage", inputCalendar.getPopupSelectMonthMessage());
            }
            if (inputCalendar.getPopupSelectYearMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, "jscalendarSelectYearMessage", inputCalendar.getPopupSelectYearMessage());
            }
            if (inputCalendar.getPopupSelectDateMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, "jscalendarSelectDateMessage", inputCalendar.getPopupSelectDateMessage());
            }
        }
        return script.toString();
    }

    private static void setIntegerVariable(StringBuffer script, String name, int value) {
        script.append(name);
        script.append(" = ");
        script.append(value);
        script.append(";\n");
    }

    private static void setStringVariable(StringBuffer script, String name, String value) {
        script.append(name);
        script.append(" = \"");
        script.append(value);
        script.append("\";\n");
    }

    private static void defineStringArray(StringBuffer script, String arrayName, String[] array) {
        script.append(arrayName);
        script.append(" = new Array(");
        int i = 0;
        while (i < array.length) {
            if (i != 0) {
                script.append(",");
            }
            script.append("\"");
            script.append(array[i]);
            script.append("\"");
            ++i;
        }
        script.append(");");
    }

    private String getScriptBtnText(String clientId, String dateFormat, String popupButtonString) {
        StringBuffer script = new StringBuffer();
        script.append("if (!document.layers) {\n");
        script.append("document.write(");
        script.append("\"<input type='button' onclick='jscalendarPopUpCalendar(this,this.form.elements[\\\"");
        script.append(clientId);
        script.append("\\\"],\\\"");
        script.append(dateFormat);
        script.append("\\\")' value='");
        if (popupButtonString == null) {
            popupButtonString = "...";
        }
        script.append(popupButtonString);
        script.append("'/>\"");
        script.append(");");
        script.append("\n}");
        return script.toString();
    }

    private void writeMonthYearHeader(FacesContext facesContext, ResponseWriter writer, UIInput inputComponent, Calendar timeKeeper, int currentDay, String[] weekdays, String[] months) throws IOException {
        Calendar cal = this.shiftMonth(facesContext, timeKeeper, currentDay, -1);
        this.writeCell(facesContext, writer, inputComponent, "<", cal.getTime(), null);
        writer.startElement("td", inputComponent);
        writer.writeAttribute("colspan", new Integer(weekdays.length - 2), null);
        writer.writeText(months[timeKeeper.get(2)] + " " + timeKeeper.get(1), null);
        writer.endElement("td");
        cal = this.shiftMonth(facesContext, timeKeeper, currentDay, 1);
        this.writeCell(facesContext, writer, inputComponent, ">", cal.getTime(), null);
    }

    private Calendar shiftMonth(FacesContext facesContext, Calendar timeKeeper, int currentDay, int shift) {
        Calendar cal = this.copyCalendar(facesContext, timeKeeper);
        cal.set(2, cal.get(2) + shift);
        if (currentDay > cal.getActualMaximum(5)) {
            currentDay = cal.getActualMaximum(5);
        }
        cal.set(5, currentDay);
        return cal;
    }

    private Calendar copyCalendar(FacesContext facesContext, Calendar timeKeeper) {
        Calendar cal = Calendar.getInstance(facesContext.getViewRoot().getLocale());
        cal.set(1, timeKeeper.get(1));
        cal.set(2, timeKeeper.get(2));
        cal.set(11, timeKeeper.get(11));
        cal.set(12, timeKeeper.get(12));
        cal.set(13, timeKeeper.get(13));
        cal.set(14, timeKeeper.get(14));
        return cal;
    }

    private void writeWeekDayNameHeader(int weekStartsAtDayIndex, String[] weekdays, FacesContext facesContext, ResponseWriter writer, UIInput inputComponent) throws IOException {
        int i = weekStartsAtDayIndex;
        while (i < weekdays.length) {
            this.writeCell(facesContext, writer, inputComponent, weekdays[i], null, null);
            ++i;
        }
        int i2 = 0;
        while (i2 < weekStartsAtDayIndex) {
            this.writeCell(facesContext, writer, inputComponent, weekdays[i2], null, null);
            ++i2;
        }
    }

    private void writeDays(FacesContext facesContext, ResponseWriter writer, HtmlInputCalendar inputComponent, Calendar timeKeeper, int currentDay, int weekStartsAtDayIndex, int weekDayOfFirstDayOfMonth, int lastDayInMonth, String[] weekdays) throws IOException {
        int space;
        int n = space = weekStartsAtDayIndex < weekDayOfFirstDayOfMonth ? weekDayOfFirstDayOfMonth - weekStartsAtDayIndex : weekdays.length - weekStartsAtDayIndex + weekDayOfFirstDayOfMonth;
        if (space == weekdays.length) {
            space = 0;
        }
        int columnIndexCounter = 0;
        int i = 0;
        while (i < space) {
            if (columnIndexCounter == 0) {
                writer.startElement("tr", inputComponent);
            }
            this.writeCell(facesContext, writer, inputComponent, "", null, inputComponent.getDayCellClass());
            ++columnIndexCounter;
            ++i;
        }
        int i2 = 0;
        while (i2 < lastDayInMonth) {
            if (columnIndexCounter == 0) {
                writer.startElement("tr", inputComponent);
            }
            Calendar cal = this.copyCalendar(facesContext, timeKeeper);
            cal.set(5, i2 + 1);
            String cellStyle = inputComponent.getDayCellClass();
            if (currentDay - 1 == i2) {
                cellStyle = inputComponent.getCurrentDayCellClass();
            }
            this.writeCell(facesContext, writer, inputComponent, String.valueOf(i2 + 1), cal.getTime(), cellStyle);
            if (++columnIndexCounter == weekdays.length) {
                writer.endElement("tr");
                HtmlRendererUtils.writePrettyLineSeparator(facesContext);
                columnIndexCounter = 0;
            }
            ++i2;
        }
        if (columnIndexCounter != 0) {
            int i3 = columnIndexCounter;
            while (i3 < weekdays.length) {
                this.writeCell(facesContext, writer, inputComponent, "", null, inputComponent.getDayCellClass());
                ++i3;
            }
            writer.endElement("tr");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        }
    }

    private void writeCell(FacesContext facesContext, ResponseWriter writer, UIInput component, String content, Date valueForLink, String styleClass) throws IOException {
        writer.startElement("td", component);
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, null);
        }
        if (valueForLink == null) {
            writer.writeText(content, "value");
        } else {
            this.writeLink(content, component, facesContext, valueForLink);
        }
        writer.endElement("td");
    }

    private void writeLink(String content, UIInput component, FacesContext facesContext, Date valueForLink) throws IOException {
        Converter converter = this.getConverter(component);
        Application application = facesContext.getApplication();
        HtmlCommandLink link = (HtmlCommandLink)application.createComponent("javax.faces.HtmlCommandLink");
        link.setId(component.getId() + "_" + valueForLink.getTime() + "_link");
        link.setTransient(true);
        link.setImmediate(component.isImmediate());
        HtmlOutputText text = (HtmlOutputText)application.createComponent("javax.faces.HtmlOutputText");
        text.setValue(content);
        text.setId(component.getId() + "_" + valueForLink.getTime() + "_text");
        text.setTransient(true);
        UIParameter parameter = (UIParameter)application.createComponent("javax.faces.Parameter");
        parameter.setId(component.getId() + "_" + valueForLink.getTime() + "_param");
        parameter.setTransient(true);
        parameter.setName(component.getClientId(facesContext));
        parameter.setValue(converter.getAsString(facesContext, component, valueForLink));
        component.getChildren().add(link);
        link.getChildren().add(parameter);
        link.getChildren().add(text);
        RendererUtils.renderChild(facesContext, link);
    }

    private Converter getConverter(UIInput component) {
        Converter converter = component.getConverter();
        if (converter == null) {
            converter = new CalendarDateTimeConverter();
        }
        return converter;
    }

    private int mapCalendarDayToCommonDay(int day) {
        switch (day) {
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 1: {
                return 6;
            }
        }
        return 0;
    }

    private static String[] mapWeekdays(DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getShortWeekdays();
        weekdays[0] = localeWeekdays[2];
        weekdays[1] = localeWeekdays[3];
        weekdays[2] = localeWeekdays[4];
        weekdays[3] = localeWeekdays[5];
        weekdays[4] = localeWeekdays[6];
        weekdays[5] = localeWeekdays[7];
        weekdays[6] = localeWeekdays[1];
        return weekdays;
    }

    private static String[] mapWeekdaysStartingWithSunday(DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getShortWeekdays();
        weekdays[0] = localeWeekdays[1];
        weekdays[1] = localeWeekdays[2];
        weekdays[2] = localeWeekdays[3];
        weekdays[3] = localeWeekdays[4];
        weekdays[4] = localeWeekdays[5];
        weekdays[5] = localeWeekdays[6];
        weekdays[6] = localeWeekdays[7];
        return weekdays;
    }

    public static String[] mapMonths(DateFormatSymbols symbols) {
        String[] months = new String[12];
        String[] localeMonths = symbols.getMonths();
        months[0] = localeMonths[0];
        months[1] = localeMonths[1];
        months[2] = localeMonths[2];
        months[3] = localeMonths[3];
        months[4] = localeMonths[4];
        months[5] = localeMonths[5];
        months[6] = localeMonths[6];
        months[7] = localeMonths[7];
        months[8] = localeMonths[8];
        months[9] = localeMonths[9];
        months[10] = localeMonths[10];
        months[11] = localeMonths[11];
        return months;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity(facesContext, component, class$org$apache$myfaces$custom$calendar$HtmlInputCalendar == null ? (class$org$apache$myfaces$custom$calendar$HtmlInputCalendar = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlInputCalendar")) : class$org$apache$myfaces$custom$calendar$HtmlInputCalendar);
        HtmlRendererUtils.decodeUIInput(facesContext, component);
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$calendar$HtmlInputCalendar == null ? (class$org$apache$myfaces$custom$calendar$HtmlInputCalendar = HtmlCalendarRenderer.class$("org.apache.myfaces.custom.calendar.HtmlInputCalendar")) : class$org$apache$myfaces$custom$calendar$HtmlInputCalendar);
        UIInput uiInput = (UIInput)uiComponent;
        Converter converter = uiInput.getConverter();
        if (converter == null) {
            converter = new CalendarDateTimeConverter();
        }
        if (submittedValue != null && !(submittedValue instanceof String)) {
            throw new IllegalArgumentException("Submitted value of type String expected");
        }
        return converter.getAsObject(facesContext, uiComponent, (String)submittedValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CalendarDateTimeConverter
    implements Converter {
        public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String s) {
            if (s == null || s.trim().length() == 0) {
                return null;
            }
            SimpleDateFormat dateFormat = null;
            if (uiComponent instanceof HtmlInputCalendar && ((HtmlInputCalendar)uiComponent).isRenderAsPopup()) {
                String popupDateFormat = ((HtmlInputCalendar)uiComponent).getPopupDateFormat();
                dateFormat = new SimpleDateFormat(CalendarDateTimeConverter.createJSPopupFormat(facesContext, popupDateFormat));
            } else {
                dateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
            }
            try {
                return dateFormat.parse(s);
            }
            catch (ParseException e) {
                ConverterException ex = new ConverterException(e);
                throw ex;
            }
        }

        public static String createJSPopupFormat(FacesContext facesContext, String popupDateFormat) {
            if (popupDateFormat == null) {
                SimpleDateFormat defaultDateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
                popupDateFormat = defaultDateFormat.toPattern();
            }
            StringBuffer jsPopupDateFormat = new StringBuffer();
            int i = 0;
            while (i < popupDateFormat.length()) {
                char c = popupDateFormat.charAt(i);
                if (c == 'M') {
                    jsPopupDateFormat.append('M');
                } else if (c == 'd') {
                    jsPopupDateFormat.append('d');
                } else if (c == 'y') {
                    jsPopupDateFormat.append('y');
                } else if (c == ' ') {
                    jsPopupDateFormat.append(' ');
                } else if (c == '.') {
                    jsPopupDateFormat.append('.');
                } else if (c == '/') {
                    jsPopupDateFormat.append('/');
                }
                ++i;
            }
            return jsPopupDateFormat.toString().trim();
        }

        public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object o) {
            Date date = (Date)o;
            if (date == null) {
                return null;
            }
            SimpleDateFormat dateFormat = null;
            if (uiComponent instanceof HtmlInputCalendar && ((HtmlInputCalendar)uiComponent).isRenderAsPopup()) {
                String popupDateFormat = ((HtmlInputCalendar)uiComponent).getPopupDateFormat();
                dateFormat = new SimpleDateFormat(CalendarDateTimeConverter.createJSPopupFormat(facesContext, popupDateFormat));
            } else {
                dateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
            }
            return dateFormat.format(date);
        }

        private static SimpleDateFormat createStandardDateFormat(FacesContext facesContext) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, facesContext.getViewRoot().getLocale());
            if (dateFormat instanceof SimpleDateFormat) {
                return (SimpleDateFormat)dateFormat;
            }
            return new SimpleDateFormat("dd.MM.yyyy");
        }
    }
}

