/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.validator.Validator;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.ActionListenerImpl;
import org.apache.myfaces.application.NavigationHandlerImpl;
import org.apache.myfaces.application.jsp.JspStateManagerImpl;
import org.apache.myfaces.application.jsp.JspViewHandlerImpl;
import org.apache.myfaces.config.impl.digester.elements.Property;
import org.apache.myfaces.el.MethodBindingImpl;
import org.apache.myfaces.el.PropertyResolverImpl;
import org.apache.myfaces.el.ValueBindingImpl;
import org.apache.myfaces.el.VariableResolverImpl;
import org.apache.myfaces.util.BiLevelCacheMap;
import org.apache.myfaces.util.ClassUtils;

public class ApplicationImpl
extends Application {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$application$ApplicationImpl == null ? (class$org$apache$myfaces$application$ApplicationImpl = ApplicationImpl.class$("org.apache.myfaces.application.ApplicationImpl")) : class$org$apache$myfaces$application$ApplicationImpl));
    private final Map _valueBindingCache = new BiLevelCacheMap(90){

        protected Object newInstance(Object key) {
            return new ValueBindingImpl(ApplicationImpl.this, (String)key);
        }
    };
    private Collection _supportedLocales = Collections.EMPTY_SET;
    private Locale _defaultLocale = Locale.getDefault();
    private String _messageBundle;
    private ViewHandler _viewHandler;
    private NavigationHandler _navigationHandler;
    private VariableResolver _variableResolver;
    private PropertyResolver _propertyResolver;
    private ActionListener _actionListener;
    private String _defaultRenderKitId = "HTML_BASIC";
    private StateManager _stateManager;
    private final Map _converterIdToClassMap = Collections.synchronizedMap(new HashMap());
    private final Map _converterClassToClassMap = Collections.synchronizedMap(new HashMap());
    private final Map _converterClassNameToConfigurationMap = Collections.synchronizedMap(new HashMap());
    private final Map _componentClassMap = Collections.synchronizedMap(new HashMap());
    private final Map _validatorClassMap = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$apache$myfaces$application$ApplicationImpl;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Character;

    public ApplicationImpl() {
        this._viewHandler = new JspViewHandlerImpl();
        this._navigationHandler = new NavigationHandlerImpl();
        this._variableResolver = new VariableResolverImpl();
        this._propertyResolver = new PropertyResolverImpl();
        this._actionListener = new ActionListenerImpl();
        this._stateManager = new JspStateManagerImpl();
        if (log.isTraceEnabled()) {
            log.trace((Object)"New Application instance created");
        }
    }

    public void setActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            log.error((Object)"setting actionListener to null is not allowed");
            throw new NullPointerException("setting actionListener to null is not allowed");
        }
        this._actionListener = actionListener;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set actionListener = " + actionListener.getClass().getName()));
        }
    }

    public ActionListener getActionListener() {
        return this._actionListener;
    }

    public Iterator getComponentTypes() {
        return this._componentClassMap.keySet().iterator();
    }

    public Iterator getConverterIds() {
        return this._converterIdToClassMap.keySet().iterator();
    }

    public Iterator getConverterTypes() {
        return this._converterClassToClassMap.keySet().iterator();
    }

    public void setDefaultLocale(Locale locale) {
        if (locale == null) {
            log.error((Object)"setting locale to null is not allowed");
            throw new NullPointerException("setting locale to null is not allowed");
        }
        this._defaultLocale = locale;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set defaultLocale = " + locale.getCountry() + " " + locale.getLanguage()));
        }
    }

    public Locale getDefaultLocale() {
        return this._defaultLocale;
    }

    public void setMessageBundle(String messageBundle) {
        if (messageBundle == null) {
            log.error((Object)"setting messageBundle to null is not allowed");
            throw new NullPointerException("setting messageBundle to null is not allowed");
        }
        this._messageBundle = messageBundle;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set MessageBundle = " + messageBundle));
        }
    }

    public String getMessageBundle() {
        return this._messageBundle;
    }

    public void setNavigationHandler(NavigationHandler navigationHandler) {
        if (navigationHandler == null) {
            log.error((Object)"setting navigationHandler to null is not allowed");
            throw new NullPointerException("setting navigationHandler to null is not allowed");
        }
        this._navigationHandler = navigationHandler;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set NavigationHandler = " + navigationHandler.getClass().getName()));
        }
    }

    public NavigationHandler getNavigationHandler() {
        return this._navigationHandler;
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        if (propertyResolver == null) {
            log.error((Object)"setting propertyResolver to null is not allowed");
            throw new NullPointerException("setting propertyResolver to null is not allowed");
        }
        this._propertyResolver = propertyResolver;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set PropertyResolver = " + propertyResolver.getClass().getName()));
        }
    }

    public PropertyResolver getPropertyResolver() {
        return this._propertyResolver;
    }

    public void setSupportedLocales(Collection locales) {
        if (locales == null) {
            log.error((Object)"setting supportedLocales to null is not allowed");
            throw new NullPointerException("setting supportedLocales to null is not allowed");
        }
        this._supportedLocales = locales;
        if (log.isTraceEnabled()) {
            log.trace((Object)"set SupportedLocales");
        }
    }

    public Iterator getSupportedLocales() {
        return this._supportedLocales.iterator();
    }

    public Iterator getValidatorIds() {
        return this._validatorClassMap.keySet().iterator();
    }

    public void setVariableResolver(VariableResolver variableResolver) {
        if (variableResolver == null) {
            log.error((Object)"setting variableResolver to null is not allowed");
            throw new NullPointerException("setting variableResolver to null is not allowed");
        }
        this._variableResolver = variableResolver;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set VariableResolver = " + variableResolver.getClass().getName()));
        }
    }

    public VariableResolver getVariableResolver() {
        return this._variableResolver;
    }

    public void setViewHandler(ViewHandler viewHandler) {
        if (viewHandler == null) {
            log.error((Object)"setting viewHandler to null is not allowed");
            throw new NullPointerException("setting viewHandler to null is not allowed");
        }
        this._viewHandler = viewHandler;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set ViewHandler = " + viewHandler.getClass().getName()));
        }
    }

    public ViewHandler getViewHandler() {
        return this._viewHandler;
    }

    public void addComponent(String componentType, String componentClassName) {
        if (componentType == null || componentType.length() == 0) {
            log.error((Object)"addComponent: componentType = null is not allowed");
            throw new NullPointerException("addComponent: componentType = null ist not allowed");
        }
        if (componentClassName == null || componentClassName.length() == 0) {
            log.error((Object)"addComponent: component = null is not allowed");
            throw new NullPointerException("addComponent: component = null is not allowed");
        }
        try {
            this._componentClassMap.put(componentType, ClassUtils.simpleClassForName(componentClassName));
            if (log.isTraceEnabled()) {
                log.trace((Object)("add Component class = " + componentClassName + " for type = " + componentType));
            }
        }
        catch (Exception e) {
            log.error((Object)("Component class " + componentClassName + " not found"), (Throwable)e);
        }
    }

    public void addConverter(String converterId, String converterClass) {
        if (converterId == null || converterId.length() == 0) {
            log.error((Object)"addConverter: converterId = null is not allowed");
            throw new NullPointerException("addConverter: converterId = null ist not allowed");
        }
        if (converterClass == null || converterClass.length() == 0) {
            log.error((Object)"addConverter: converterClass = null is not allowed");
            throw new NullPointerException("addConverter: converterClass = null ist not allowed");
        }
        try {
            this._converterIdToClassMap.put(converterId, ClassUtils.simpleClassForName(converterClass));
            if (log.isTraceEnabled()) {
                log.trace((Object)("add Converter id = " + converterId + " converterClass = " + converterClass));
            }
        }
        catch (Exception e) {
            log.error((Object)("Converter class " + converterClass + " not found"), (Throwable)e);
        }
    }

    public void addConverter(Class targetClass, String converterClass) {
        if (targetClass == null) {
            log.error((Object)"addConverter: targetClass = null is not allowed");
            throw new NullPointerException("addConverter: targetClass = null ist not allowed");
        }
        if (converterClass == null || converterClass.length() == 0) {
            log.error((Object)"addConverter: converterClass = null is not allowed");
            throw new NullPointerException("addConverter: converterClass = null ist not allowed");
        }
        try {
            this._converterClassToClassMap.put(targetClass, ClassUtils.simpleClassForName(converterClass));
            if (log.isTraceEnabled()) {
                log.trace((Object)("add Converter for class = " + targetClass + " converterClass = " + converterClass));
            }
        }
        catch (Exception e) {
            log.error((Object)("Converter class " + converterClass + " not found"), (Throwable)e);
        }
    }

    public void addConverterConfiguration(String converterClassName, org.apache.myfaces.config.impl.digester.elements.Converter configuration) {
        if (converterClassName == null || converterClassName.length() == 0) {
            log.error((Object)"addConverterConfiguration: converterClassName = null is not allowed");
            throw new NullPointerException("addConverterConfiguration: converterClassName = null ist not allowed");
        }
        if (configuration == null) {
            log.error((Object)"addConverterConfiguration: configuration = null is not allowed");
            throw new NullPointerException("addConverterConfiguration: configuration = null ist not allowed");
        }
        this._converterClassNameToConfigurationMap.put(converterClassName, configuration);
    }

    public void addValidator(String validatorId, String validatorClass) {
        if (validatorId == null || validatorId.length() == 0) {
            log.error((Object)"addValidator: validatorId = null is not allowed");
            throw new NullPointerException("addValidator: validatorId = null ist not allowed");
        }
        if (validatorClass == null || validatorClass.length() == 0) {
            log.error((Object)"addValidator:  validatorClass = null is not allowed");
            throw new NullPointerException("addValidator:  validatorClass = null ist not allowed");
        }
        try {
            this._validatorClassMap.put(validatorId, ClassUtils.simpleClassForName(validatorClass));
            if (log.isTraceEnabled()) {
                log.trace((Object)("add Validator id = " + validatorId + " class = " + validatorClass));
            }
        }
        catch (Exception e) {
            log.error((Object)("Validator class " + validatorClass + " not found"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIComponent createComponent(String componentType) throws FacesException {
        Class componentClass;
        if (componentType == null || componentType.length() == 0) {
            log.error((Object)"createComponent: componentType = null is not allowed");
            throw new NullPointerException("createComponent: componentType = null is not allowed");
        }
        Map map = this._componentClassMap;
        synchronized (map) {
            componentClass = (Class)this._componentClassMap.get(componentType);
        }
        if (componentClass == null) {
            log.error((Object)("Undefined component type " + componentType));
            throw new FacesException("Undefined component type " + componentType);
        }
        try {
            return (UIComponent)componentClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate component componentType = " + componentType), (Throwable)e);
            throw new FacesException("Could not instantiate component componentType = " + componentType, e);
        }
    }

    public UIComponent createComponent(ValueBinding valueBinding, FacesContext facesContext, String componentType) throws FacesException {
        if (valueBinding == null) {
            log.error((Object)"createComponent: valueBinding = null is not allowed");
            throw new NullPointerException("createComponent: valueBinding = null ist not allowed");
        }
        if (facesContext == null) {
            log.error((Object)"createComponent: facesContext = null is not allowed");
            throw new NullPointerException("createComponent: facesContext = null ist not allowed");
        }
        if (componentType == null || componentType.length() == 0) {
            log.error((Object)"createComponent: componentType = null is not allowed");
            throw new NullPointerException("createComponent: componentType = null ist not allowed");
        }
        Object obj = valueBinding.getValue(facesContext);
        if (obj instanceof UIComponent) {
            return (UIComponent)obj;
        }
        UIComponent component = this.createComponent(componentType);
        valueBinding.setValue(facesContext, component);
        return component;
    }

    public Converter createConverter(String converterId) {
        if (converterId == null || converterId.length() == 0) {
            log.error((Object)"createConverter: converterId = null is not allowed");
            throw new NullPointerException("createConverter: converterId = null ist not allowed");
        }
        Class converterClass = (Class)this._converterIdToClassMap.get(converterId);
        try {
            return (Converter)converterClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate converter " + converterClass), (Throwable)e);
            throw new FacesException("Could not instantiate converter: " + converterClass, e);
        }
    }

    public Converter createConverter(Class targetClass) {
        if (targetClass == null) {
            log.error((Object)"createConverter: targetClass = null is not allowed");
            throw new NullPointerException("createConverter: targetClass = null ist not allowed");
        }
        Converter converter = this.internalCreateConverter(targetClass);
        return converter;
    }

    private Converter internalCreateConverter(Class targetClass) {
        Class<?>[] interfaces;
        Class converterClass = (Class)this._converterClassToClassMap.get(targetClass);
        if (converterClass == null && (interfaces = targetClass.getInterfaces()) != null) {
            int i = 0;
            int len = interfaces.length;
            while (i < len) {
                Converter converter = this.internalCreateConverter(interfaces[i]);
                if (converter != null) {
                    return converter;
                }
                ++i;
            }
        }
        if (converterClass != null) {
            try {
                Converter converter = (Converter)converterClass.newInstance();
                org.apache.myfaces.config.impl.digester.elements.Converter converterConfig = (org.apache.myfaces.config.impl.digester.elements.Converter)this._converterClassNameToConfigurationMap.get(converterClass.getName());
                Iterator it = converterConfig.getProperties();
                while (it.hasNext()) {
                    Property property = (Property)it.next();
                    try {
                        BeanUtils.setProperty((Object)converter, (String)property.getPropertyName(), (Object)property.getDefaultValue());
                    }
                    catch (Throwable th) {
                        log.error((Object)("Initializing converter : " + converterClass.getName() + " with property : " + property.getPropertyName() + " and value : " + property.getDefaultValue() + " failed."));
                    }
                }
                return converter;
            }
            catch (Exception e) {
                log.error((Object)("Could not instantiate converter " + converterClass), (Throwable)e);
                throw new FacesException("Could not instantiate converter: " + converterClass, e);
            }
        }
        if (targetClass == Long.TYPE) {
            return this.internalCreateConverter(class$java$lang$Long == null ? (class$java$lang$Long = ApplicationImpl.class$("java.lang.Long")) : class$java$lang$Long);
        }
        if (targetClass == Boolean.TYPE) {
            return this.internalCreateConverter(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ApplicationImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        }
        if (targetClass == Double.TYPE) {
            return this.internalCreateConverter(class$java$lang$Double == null ? (class$java$lang$Double = ApplicationImpl.class$("java.lang.Double")) : class$java$lang$Double);
        }
        if (targetClass == Byte.TYPE) {
            return this.internalCreateConverter(class$java$lang$Byte == null ? (class$java$lang$Byte = ApplicationImpl.class$("java.lang.Byte")) : class$java$lang$Byte);
        }
        if (targetClass == Short.TYPE) {
            return this.internalCreateConverter(class$java$lang$Short == null ? (class$java$lang$Short = ApplicationImpl.class$("java.lang.Short")) : class$java$lang$Short);
        }
        if (targetClass == Integer.TYPE) {
            return this.internalCreateConverter(class$java$lang$Integer == null ? (class$java$lang$Integer = ApplicationImpl.class$("java.lang.Integer")) : class$java$lang$Integer);
        }
        if (targetClass == Float.TYPE) {
            return this.internalCreateConverter(class$java$lang$Float == null ? (class$java$lang$Float = ApplicationImpl.class$("java.lang.Float")) : class$java$lang$Float);
        }
        if (targetClass == Character.TYPE) {
            return this.internalCreateConverter(class$java$lang$Character == null ? (class$java$lang$Character = ApplicationImpl.class$("java.lang.Character")) : class$java$lang$Character);
        }
        Class superClazz = targetClass.getSuperclass();
        if (superClazz != null) {
            return this.internalCreateConverter(superClazz);
        }
        return null;
    }

    public synchronized MethodBinding createMethodBinding(String reference, Class[] params) throws ReferenceSyntaxException {
        if (reference == null || reference.length() == 0) {
            log.error((Object)"createMethodBinding: reference = null is not allowed");
            throw new NullPointerException("createMethodBinding: reference = null ist not allowed");
        }
        return new MethodBindingImpl(this, reference, params);
    }

    public Validator createValidator(String validatorId) throws FacesException {
        if (validatorId == null || validatorId.length() == 0) {
            log.error((Object)"createValidator: validatorId = null is not allowed");
            throw new NullPointerException("createValidator: validatorId = null ist not allowed");
        }
        Class validatorClass = (Class)this._validatorClassMap.get(validatorId);
        if (validatorClass == null) {
            String message = "Unknown converter id '" + validatorId + "'.";
            log.error((Object)message);
            throw new FacesException(message);
        }
        try {
            return (Validator)validatorClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate converter " + validatorClass), (Throwable)e);
            throw new FacesException("Could not instantiate converter: " + validatorClass, e);
        }
    }

    public ValueBinding createValueBinding(String reference) throws ReferenceSyntaxException {
        if (reference == null || reference.length() == 0) {
            log.error((Object)"createValueBinding: reference = null is not allowed");
            throw new NullPointerException("createValueBinding: reference = null is not allowed");
        }
        return (ValueBinding)this._valueBindingCache.get(reference);
    }

    public String getDefaultRenderKitId() {
        return this._defaultRenderKitId;
    }

    public void setDefaultRenderKitId(String defaultRenderKitId) {
        this._defaultRenderKitId = defaultRenderKitId;
    }

    public StateManager getStateManager() {
        return this._stateManager;
    }

    public void setStateManager(StateManager stateManager) {
        this._stateManager = stateManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

