/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.taglib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.validator.Validator;
import javax.faces.webapp.UIComponentTag;
import javax.faces.webapp.ValidatorTag;
import javax.servlet.jsp.JspException;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.jsf.util.BindingUtil;

public class S2ValidatorTag
extends ValidatorTag {
    private String binding;
    private Map attributes = new HashMap();

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        if (binding != null && !UIComponentTag.isValueReference((String)binding)) {
            throw new IllegalArgumentException("binding");
        }
        this.binding = binding;
    }

    public void addAttribute(String name, String value) {
        if ("binding".equalsIgnoreCase(name)) {
            this.setBinding(value);
        } else {
            this.attributes.put(name, value);
        }
    }

    public void release() {
        super.release();
        this.binding = null;
        this.attributes.clear();
    }

    protected Validator createValidator() throws JspException {
        if (this.binding == null) {
            throw new EmptyRuntimeException("binding");
        }
        Validator validator = (Validator)BindingUtil.resolveBinding(this.binding);
        this.setupAttributes(validator);
        return validator;
    }

    protected void setupAttributes(Validator validator) {
        if (this.attributes.isEmpty()) {
            return;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(validator.getClass());
        Iterator i = this.attributes.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!beanDesc.hasPropertyDesc(name)) continue;
            Object value = this.attributes.get(name);
            String s = (String)value;
            if (UIComponentTag.isValueReference((String)s)) {
                value = BindingUtil.resolveBinding(s);
            }
            PropertyDesc pd = beanDesc.getPropertyDesc(name);
            pd.setValue((Object)validator, value);
        }
    }
}

