/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.validator.factory;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.Msg;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.util.BooleanConversionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.util.ConstantValueUtil;
import org.seasar.struts.validator.factory.AbstractValidatorAnnotationHandler;

public class ConstantValidatorAnnotationHandler
extends AbstractValidatorAnnotationHandler {
    private static final String VALIDATOR_SUFFIX = "_VALIDATOR";
    private static final String ARG_SUFFIX = "_VALIDATOR_ARG";
    private static final String MESSAGE_SUFFIX = "_VALIDATOR_MESSAGE";
    private static final String TYPE = "type";
    private static final String NO_VALIDATE = "noValidate";

    protected Field createField(Form form, BeanDesc beanDesc, PropertyDesc propDesc) {
        if (!propDesc.hasWriteMethod()) {
            return null;
        }
        String propName = propDesc.getPropertyName();
        if (form.getField(propName) != null) {
            return null;
        }
        List parameters = this.getValidatorParameters(beanDesc, propDesc);
        if (this.noValidate(parameters)) {
            return null;
        }
        Method method = propDesc.getWriteMethod();
        String depends = this.createDepends(method, parameters);
        if (depends == null) {
            return null;
        }
        Field field = new Field();
        this.addMessage(field, beanDesc, propDesc);
        this.addArg(field, beanDesc, propDesc);
        field.setDepends(depends);
        field.setProperty(propDesc.getPropertyName());
        this.registConfig(field, method, parameters);
        return field;
    }

    private List getValidatorParameters(BeanDesc beanDesc, PropertyDesc propDesc) {
        ArrayList<Map> result = new ArrayList<Map>();
        String fieldName = propDesc.getPropertyName() + VALIDATOR_SUFFIX;
        Map parameter = this.getValidatorParameter(beanDesc, fieldName);
        if (parameter != null) {
            result.add(parameter);
        }
        int i = 0;
        while (this.hasValidatorParameter(beanDesc, fieldName, i)) {
            parameter = this.getValidatorParameter(beanDesc, fieldName, i);
            if (parameter != null) {
                result.add(parameter);
            }
            ++i;
        }
        return result;
    }

    private boolean hasValidatorParameter(BeanDesc beanDesc, String fieldName) {
        return beanDesc.hasField(fieldName);
    }

    private Map getValidatorParameter(BeanDesc beanDesc, String fieldName) {
        if (!beanDesc.hasField(fieldName)) {
            return null;
        }
        String value = (String)beanDesc.getFieldValue(fieldName, null);
        return ConstantValueUtil.toMap(value, TYPE);
    }

    private boolean hasValidatorParameter(BeanDesc beanDesc, String fieldName, int index) {
        return this.hasValidatorParameter(beanDesc, fieldName + "_" + Integer.toString(index));
    }

    private Map getValidatorParameter(BeanDesc beanDesc, String fieldName, int index) {
        return this.getValidatorParameter(beanDesc, fieldName + "_" + Integer.toString(index));
    }

    private boolean noValidate(List parameters) {
        Iterator it = parameters.iterator();
        while (it.hasNext()) {
            Map parameter = (Map)it.next();
            String type = (String)parameter.get(TYPE);
            if (!NO_VALIDATE.equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    private void registConfig(Field field, Method method, List parameters) {
        this.registAutoTypeValidatorConfig(field, method);
        Iterator it = parameters.iterator();
        while (it.hasNext()) {
            Map parameter = (Map)it.next();
            String type = (String)parameter.get(TYPE);
            if (!this.hasConfigRegister(type)) continue;
            this.executeConfigRegister(field, type, parameter);
        }
    }

    private String createDepends(Method method, List parameters) {
        StringBuffer depends = new StringBuffer("");
        String autoTypeValidatorName = this.getAutoTypeValidatorName(method);
        if (!StringUtil.isEmpty((String)autoTypeValidatorName)) {
            depends.append(autoTypeValidatorName).append(",");
        }
        Iterator it = parameters.iterator();
        while (it.hasNext()) {
            Map parameter = (Map)it.next();
            depends.append(parameter.get(TYPE)).append(",");
        }
        if (depends.length() < 1) {
            return null;
        }
        depends.setLength(depends.length() - 1);
        return depends.toString();
    }

    private void addArg(Field field, BeanDesc beanDesc, PropertyDesc propDesc) {
        String fieldName = propDesc.getPropertyName() + ARG_SUFFIX;
        if (!beanDesc.hasField(fieldName)) {
            return;
        }
        String value = (String)beanDesc.getFieldValue(fieldName, null);
        Map parameter = ConstantValueUtil.toMap(value, "key");
        String key = (String)parameter.get("key");
        String resourceStr = (String)parameter.get("resource");
        boolean resource = true;
        if (!StringUtil.isEmpty((String)resourceStr)) {
            resource = BooleanConversionUtil.toPrimitiveBoolean((Object)resourceStr);
        }
        Arg arg = new Arg();
        arg.setKey(key);
        arg.setResource(resource);
        arg.setPosition(0);
        field.addArg(arg);
    }

    private void addMessage(Field field, BeanDesc beanDesc, PropertyDesc propDesc) {
        String fieldName = propDesc.getPropertyName() + MESSAGE_SUFFIX;
        if (!beanDesc.hasField(fieldName)) {
            return;
        }
        String value = (String)beanDesc.getFieldValue(fieldName, null);
        Map parameter = ConstantValueUtil.toMap(value);
        String name = (String)parameter.get("name");
        String key = (String)parameter.get("key");
        String bundle = (String)parameter.get("bundle");
        String resourceStr = (String)parameter.get("resource");
        boolean resource = true;
        if (!StringUtil.isEmpty((String)resourceStr)) {
            resource = BooleanConversionUtil.toPrimitiveBoolean((Object)resourceStr);
        }
        Msg msg = new Msg();
        msg.setBundle(bundle);
        msg.setKey(key);
        msg.setName(name);
        msg.setResource(resource);
        field.addMsg(msg);
    }
}

