package org.seasar.framework.container.impl;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;

/**
 * <p>
 * {@link S2ContainerImpl}̐U镑ύXł悤ɂ邽߂̃GNXeV|CgłBC^tF[X {@link Provider}
 * Ǝ̃NXo^邱ƂŁA {@link S2ContainerImpl}̐U镑
 * {@link org.seasar.framework.container.S2Container}ɏȂ悤ɕύX邱Ƃo܂B
 * </p>
 * <p>
 * {@link S2ContainerImpl}̐U镑ύX邱ƂɂA {@link org.seasar.framework.container.S2Container}
 * ̎dlɈˑR|[lgS2֘Av_Ngɓ삵ȂȂ邱Ƃ蓾܂B <strong>Own Risk </strong>ŎgpĂB
 * <p>
 * ̃NX {@link S2ContainerImpl}̎ɋˑĂ܂BɓnĈ肵̂ł <strong>Ȃ
 * </strong>Ƃ𗝉ŎgpĂB
 * </p>
 * 
 * @author koichik
 */
public final class S2ContainerBehavior {
    private static Provider provider_ = new DefaultProvider();

    private S2ContainerBehavior() {
    }

    /**
     * o^Ă {@link Provider}̃CX^XԂ܂B
     * 
     * @return o^Ă {@link Provider}̃CX^X
     */
    public static Provider getProvider() {
        return provider_;
    }

    /**
     * {@link Provider}̃CX^Xo^܂B
     * 
     * @param provider
     *            o^ {@link Provider}̃CX^X
     */
    public static void setProvider(final Provider provider) {
        provider_ = provider;
    }

    public static ComponentDef acquireFromGetComponent(S2Container container, final Object key) {
        return getProvider().acquireFromGetComponent(container, key);
    }

    public static ComponentDef acquireFromGetComponentDef(S2Container container, final Object key) {
        return getProvider().acquireFromGetComponentDef(container, key);
    }

    public static ComponentDef acquireFromHasComponentDef(S2Container container, final Object key) {
        return getProvider().acquireFromHasComponentDef(container, key);
    }

    public static ComponentDef acquireFromInjectDependency(S2Container container, final Object key) {
        return getProvider().acquireFromInjectDependency(container, key);
    }

    /**
     * S2Rei̐U镑񋟂邽߂̃C^tF[XłB
     * 
     * @author koichik
     */
    public interface Provider {
        /**
         * {@link S2ContainerImpl#getComponent()}R|[lg`擾ۂɌĂяo܂B <br>
         * {@link org.seasar.framework.container.S2Container#getComponent()}
         * ̎dlł́AR|[lg`Ȃꍇ
         * {@link org.seasar.framework.container.ComponentNotFoundRuntimeException}
         * X[邱ƂɂȂĂ܂B
         * 
         * @param container
         *            ĂяõReiłB
         * @param key
         *            擾R|[lg`̃L[łB
         * @return R|[lg`łBR|[lg`炸AOX[Ȃꍇɂ <code>null</code> ԂƂo܂B
         */
        ComponentDef acquireFromGetComponent(S2Container container, final Object key);

        /**
         * {@link S2ContainerImpl#getComponentDef()}R|[lg`擾ۂɌĂяo܂B <br>
         * {@link org.seasar.framework.container.S2Container#getComponentDef()}
         * ̎dlł́AR|[lg`Ȃꍇ
         * {@link org.seasar.framework.container.ComponentNotFoundRuntimeException}
         * X[邱ƂɂȂĂ܂B
         * 
         * @param container
         *            ĂяõReiłB
         * @param key
         *            擾R|[lg`̃L[łB
         * @return R|[lg`łBR|[lg`炸AOX[Ȃꍇɂ <code>null</code> ԂƂo܂B
         */
        ComponentDef acquireFromGetComponentDef(S2Container container, final Object key);

        /**
         * {@link S2ContainerImpl#hasComponent()}R|[lg`擾ۂɌĂяo܂B <br>
         * {@link org.seasar.framework.container.S2Container#hasComponent()}
         * ̎dlł́AR|[lg`ȂĂO̓X[ȂƂɂȂĂ܂B
         * 
         * @param container
         *            ĂяõReiłB
         * @param key
         *            擾R|[lg`̃L[łB
         * @return R|[lg`łBR|[lg`炸AOX[Ȃꍇɂ <code>null</code> ԂƂo܂B
         */
        ComponentDef acquireFromHasComponentDef(S2Container container, final Object key);

        /**
         * {@link S2ContainerImpl#injectDependency()}R|[lg`擾ۂɌĂяo܂B <br>
         * {@link org.seasar.framework.container.S2Container#injectDependency()}
         * ̎dlł́AR|[lg`Ȃꍇ
         * {@link org.seasar.framework.container.ComponentNotFoundRuntimeException}
         * X[邱ƂɂȂĂ܂B
         * 
         * @param container
         *            ĂяõReiłB
         * @param key
         *            擾R|[lg`̃L[łB
         * @return R|[lg`łBR|[lg`炸AOX[Ȃꍇɂ <code>null</code> ԂƂo܂B
         */
        ComponentDef acquireFromInjectDependency(S2Container container, final Object key);
    }

    /**
     * {@link org.seasar.framework.container.S2Container}̎dlɏ]U镑񋟂A {@link Provider}̎łB
     * 
     * @author koichik
     */
    public static class DefaultProvider implements Provider {
        public ComponentDef acquireFromGetComponent(final S2Container container, final Object key) {
            return acquireFromGetComponentDef(container, key);
        }

        public ComponentDef acquireFromGetComponentDef(final S2Container container, final Object key) {
            final ComponentDef cd = getComponentDef(container, key);
            if (cd == null) {
                throw new ComponentNotFoundRuntimeException(key);
            }
            return cd;
        }

        public ComponentDef acquireFromHasComponentDef(final S2Container container, final Object key) {
            return getComponentDef(container, key);
        }

        public ComponentDef acquireFromInjectDependency(final S2Container container,
                final Object key) {
            return acquireFromGetComponentDef(container, key);
        }

        protected ComponentDef getComponentDef(final S2Container container, final Object key) {
            return ((S2ContainerImpl) container).internalGetComponentDef(key);
        }
    }
}
