/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.util.LinkedHashSet;
import java.util.Set;
import org.seasar.framework.container.ExtensionNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.assembler.AssemblerFactory;
import org.seasar.framework.container.deployer.ComponentDeployerFactory;
import org.seasar.framework.container.factory.AbstractS2ContainerBuilder;
import org.seasar.framework.container.factory.CircularIncludeRuntimeException;
import org.seasar.framework.container.factory.PathResolver;
import org.seasar.framework.container.factory.ResourceResolver;
import org.seasar.framework.container.factory.S2ContainerBuilder;
import org.seasar.framework.container.factory.SimplePathResolver;
import org.seasar.framework.container.factory.XmlS2ContainerBuilder;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.util.ResourceUtil;

public final class S2ContainerFactory {
    public static final String FACTORY_CONFIG_KEY = "org.seasar.framework.container.factory.config";
    public static final String FACTORY_CONFIG_PATH = "s2container.dicon";
    public static final String DEFAULT_BUILDER_NAME = "defaultBuilder";
    protected static S2Container configurationContainer_;
    protected static Provider provider_;
    protected static S2ContainerBuilder defaultBuilder_;
    protected static ThreadLocal processingPaths_;
    static /* synthetic */ Class class$org$seasar$framework$container$factory$S2ContainerFactory$Configurator;
    static /* synthetic */ Class class$org$seasar$framework$container$factory$S2ContainerFactory$Provider;
    static /* synthetic */ Class class$org$seasar$framework$container$factory$PathResolver;
    static /* synthetic */ Class class$org$seasar$framework$container$factory$ResourceResolver;
    static /* synthetic */ Class class$org$seasar$framework$container$impl$S2ContainerBehavior$Provider;
    static /* synthetic */ Class class$org$seasar$framework$container$deployer$ComponentDeployerFactory$Provider;
    static /* synthetic */ Class class$org$seasar$framework$container$assembler$AssemblerFactory$Provider;

    public static Provider getProvider() {
        return provider_;
    }

    public static void setProvider(Provider provider) {
        provider_ = provider;
    }

    public static S2ContainerBuilder getDefaultBuilder() {
        return defaultBuilder_;
    }

    public static void setDefaultBuilder(S2ContainerBuilder defaultBuilder) {
        defaultBuilder_ = defaultBuilder;
    }

    public static S2Container create(String path) {
        return S2ContainerFactory.getProvider().create(path);
    }

    public static S2Container create(String path, ClassLoader classLoader) {
        return S2ContainerFactory.getProvider().create(path, classLoader);
    }

    public static S2Container include(S2Container parent, String path) {
        return S2ContainerFactory.getProvider().include(parent, path);
    }

    protected static void configure() {
        String configFile = System.getProperty(FACTORY_CONFIG_KEY, FACTORY_CONFIG_PATH);
        if (ResourceUtil.isExist(configFile)) {
            XmlS2ContainerBuilder builder = new XmlS2ContainerBuilder();
            configurationContainer_ = builder.build(configFile);
            Configurator configurator = configurationContainer_.hasComponentDef(class$org$seasar$framework$container$factory$S2ContainerFactory$Configurator == null ? (class$org$seasar$framework$container$factory$S2ContainerFactory$Configurator = S2ContainerFactory.class$("org.seasar.framework.container.factory.S2ContainerFactory$Configurator")) : class$org$seasar$framework$container$factory$S2ContainerFactory$Configurator) ? (Configurator)configurationContainer_.getComponent(class$org$seasar$framework$container$factory$S2ContainerFactory$Configurator == null ? (class$org$seasar$framework$container$factory$S2ContainerFactory$Configurator = S2ContainerFactory.class$("org.seasar.framework.container.factory.S2ContainerFactory$Configurator")) : class$org$seasar$framework$container$factory$S2ContainerFactory$Configurator) : new DefaultConfigurator();
            configurator.configure(configurationContainer_);
        }
    }

    protected static void enter(String path) {
        Set paths = (Set)processingPaths_.get();
        if (paths.contains(path)) {
            throw new CircularIncludeRuntimeException(path, paths);
        }
        paths.add(path);
    }

    protected static void leave(String path) {
        Set paths = (Set)processingPaths_.get();
        paths.remove(path);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        provider_ = new DefaultProvider();
        defaultBuilder_ = new XmlS2ContainerBuilder();
        processingPaths_ = new ThreadLocal(){

            protected Object initialValue() {
                return new LinkedHashSet();
            }
        };
        S2ContainerFactory.configure();
    }

    public static class DefaultConfigurator
    implements Configurator {
        public void configure(S2Container bootstrapContainer) {
            if (configurationContainer_.hasComponentDef(class$org$seasar$framework$container$factory$S2ContainerFactory$Provider == null ? (class$org$seasar$framework$container$factory$S2ContainerFactory$Provider = S2ContainerFactory.class$("org.seasar.framework.container.factory.S2ContainerFactory$Provider")) : class$org$seasar$framework$container$factory$S2ContainerFactory$Provider)) {
                provider_ = (Provider)configurationContainer_.getComponent(class$org$seasar$framework$container$factory$S2ContainerFactory$Provider == null ? (class$org$seasar$framework$container$factory$S2ContainerFactory$Provider = S2ContainerFactory.class$("org.seasar.framework.container.factory.S2ContainerFactory$Provider")) : class$org$seasar$framework$container$factory$S2ContainerFactory$Provider);
            } else if (configurationContainer_.hasComponentDef(class$org$seasar$framework$container$factory$PathResolver == null ? (class$org$seasar$framework$container$factory$PathResolver = S2ContainerFactory.class$("org.seasar.framework.container.factory.PathResolver")) : class$org$seasar$framework$container$factory$PathResolver) && provider_ instanceof DefaultProvider) {
                ((DefaultProvider)provider_).setPathResolver((PathResolver)configurationContainer_.getComponent(class$org$seasar$framework$container$factory$PathResolver == null ? (class$org$seasar$framework$container$factory$PathResolver = S2ContainerFactory.class$("org.seasar.framework.container.factory.PathResolver")) : class$org$seasar$framework$container$factory$PathResolver));
            }
            if (configurationContainer_.hasComponentDef(S2ContainerFactory.DEFAULT_BUILDER_NAME)) {
                defaultBuilder_ = (S2ContainerBuilder)configurationContainer_.getComponent(S2ContainerFactory.DEFAULT_BUILDER_NAME);
            } else if (configurationContainer_.hasComponentDef(class$org$seasar$framework$container$factory$ResourceResolver == null ? (class$org$seasar$framework$container$factory$ResourceResolver = S2ContainerFactory.class$("org.seasar.framework.container.factory.ResourceResolver")) : class$org$seasar$framework$container$factory$ResourceResolver) && defaultBuilder_ instanceof AbstractS2ContainerBuilder) {
                ((AbstractS2ContainerBuilder)defaultBuilder_).setResourceResolver((ResourceResolver)configurationContainer_.getComponent(class$org$seasar$framework$container$factory$ResourceResolver == null ? (class$org$seasar$framework$container$factory$ResourceResolver = S2ContainerFactory.class$("org.seasar.framework.container.factory.ResourceResolver")) : class$org$seasar$framework$container$factory$ResourceResolver));
            }
            if (configurationContainer_.hasComponentDef(class$org$seasar$framework$container$impl$S2ContainerBehavior$Provider == null ? (class$org$seasar$framework$container$impl$S2ContainerBehavior$Provider = S2ContainerFactory.class$("org.seasar.framework.container.impl.S2ContainerBehavior$Provider")) : class$org$seasar$framework$container$impl$S2ContainerBehavior$Provider)) {
                S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)configurationContainer_.getComponent(class$org$seasar$framework$container$impl$S2ContainerBehavior$Provider == null ? (class$org$seasar$framework$container$impl$S2ContainerBehavior$Provider = S2ContainerFactory.class$("org.seasar.framework.container.impl.S2ContainerBehavior$Provider")) : class$org$seasar$framework$container$impl$S2ContainerBehavior$Provider));
            }
            if (configurationContainer_.hasComponentDef(class$org$seasar$framework$container$deployer$ComponentDeployerFactory$Provider == null ? (class$org$seasar$framework$container$deployer$ComponentDeployerFactory$Provider = S2ContainerFactory.class$("org.seasar.framework.container.deployer.ComponentDeployerFactory$Provider")) : class$org$seasar$framework$container$deployer$ComponentDeployerFactory$Provider)) {
                ComponentDeployerFactory.setProvider((ComponentDeployerFactory.Provider)configurationContainer_.getComponent(class$org$seasar$framework$container$deployer$ComponentDeployerFactory$Provider == null ? (class$org$seasar$framework$container$deployer$ComponentDeployerFactory$Provider = S2ContainerFactory.class$("org.seasar.framework.container.deployer.ComponentDeployerFactory$Provider")) : class$org$seasar$framework$container$deployer$ComponentDeployerFactory$Provider));
            }
            if (configurationContainer_.hasComponentDef(class$org$seasar$framework$container$assembler$AssemblerFactory$Provider == null ? (class$org$seasar$framework$container$assembler$AssemblerFactory$Provider = S2ContainerFactory.class$("org.seasar.framework.container.assembler.AssemblerFactory$Provider")) : class$org$seasar$framework$container$assembler$AssemblerFactory$Provider)) {
                AssemblerFactory.setProvider((AssemblerFactory.Provider)configurationContainer_.getComponent(class$org$seasar$framework$container$assembler$AssemblerFactory$Provider == null ? (class$org$seasar$framework$container$assembler$AssemblerFactory$Provider = S2ContainerFactory.class$("org.seasar.framework.container.assembler.AssemblerFactory$Provider")) : class$org$seasar$framework$container$assembler$AssemblerFactory$Provider));
            }
        }
    }

    public static interface Configurator {
        public void configure(S2Container var1);
    }

    public static class DefaultProvider
    implements Provider {
        protected PathResolver pathResolver_ = new SimplePathResolver();

        public PathResolver getPathResolver() {
            return this.pathResolver_;
        }

        public void setPathResolver(PathResolver pathResolver) {
            this.pathResolver_ = pathResolver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public S2Container create(String path) {
            String realPath = this.pathResolver_.resolvePath(null, path);
            S2ContainerFactory.enter(realPath);
            try {
                S2Container container;
                String ext = this.getExtension(realPath);
                S2Container s2Container = container = this.getBuilder(ext).build(realPath);
                return s2Container;
            }
            finally {
                S2ContainerFactory.leave(realPath);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public S2Container create(String path, ClassLoader classLoader) {
            String realPath = this.pathResolver_.resolvePath(null, path);
            S2ContainerFactory.enter(realPath);
            try {
                S2Container container;
                String ext = this.getExtension(realPath);
                S2Container s2Container = container = this.getBuilder(ext).build(realPath, classLoader);
                return s2Container;
            }
            finally {
                S2ContainerFactory.leave(realPath);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public S2Container include(S2Container parent, String path) {
            String realPath = this.pathResolver_.resolvePath(parent.getPath(), path);
            S2ContainerFactory.enter(realPath);
            try {
                S2Container root = parent.getRoot();
                S2Container child = null;
                S2Container s2Container = root;
                synchronized (s2Container) {
                    if (root.hasDescendant(realPath)) {
                        child = root.getDescendant(realPath);
                        parent.include(child);
                    } else {
                        String ext = this.getExtension(realPath);
                        S2ContainerBuilder builder = this.getBuilder(ext);
                        child = builder.include(parent, realPath);
                        root.registerDescendant(child);
                    }
                }
                s2Container = child;
                return s2Container;
            }
            finally {
                S2ContainerFactory.leave(realPath);
            }
        }

        protected String getExtension(String path) {
            String ext = ResourceUtil.getExtension(path);
            if (ext == null) {
                throw new ExtensionNotFoundRuntimeException(path);
            }
            return ext;
        }

        protected S2ContainerBuilder getBuilder(String ext) {
            if (configurationContainer_ != null && configurationContainer_.hasComponentDef(ext)) {
                return (S2ContainerBuilder)configurationContainer_.getComponent(ext);
            }
            return defaultBuilder_;
        }
    }

    public static interface Provider {
        public S2Container create(String var1);

        public S2Container create(String var1, ClassLoader var2);

        public S2Container include(S2Container var1, String var2);
    }
}

