/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ColumnNameCache {
    private static final String HOLDER = "ZERO-POSITION-HOLDER";
    private String[] columnNameToIndexCache;

    public int getIndexForColumnName(String columnName) throws SQLException {
        int max = this.columnNameToIndexCache.length;
        for (int i = 1; i < max; ++i) {
            if (!columnName.equalsIgnoreCase(this.columnNameToIndexCache[i])) continue;
            return i;
        }
        throw new SQLException("Column [" + columnName + "] not found in result set");
    }

    public static ColumnNameCache construct(ResultSetMetaData metadata) throws SQLException {
        int columnCount = metadata.getColumnCount();
        ColumnNameCache result = new ColumnNameCache();
        result.columnNameToIndexCache = new String[columnCount + 1];
        result.columnNameToIndexCache[0] = HOLDER;
        for (int i = 1; i <= columnCount; ++i) {
            result.columnNameToIndexCache[i] = metadata.getColumnName(i);
        }
        return result;
    }
}

