package org.seasar.remoting.rmi.connector;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

import org.seasar.remoting.common.connector.impl.URLBasedConnector;
import org.seasar.remoting.common.url.URLStreamHandlerRegistry;
import org.seasar.remoting.common.url.UnopenableURLStreamHandler;
import org.seasar.remoting.rmi.adaptor.RMIAdaptor;

/**
 * RMIgpă[g\bȟĂяosRlN^̎NX.
 * 
 * @author Kenichiro Murata
 */
public class RMIConnector extends URLBasedConnector {
    private RMIAdaptor adaptorStub;

    /**
     * RXgN^.
     */
    public RMIConnector() {
        URLStreamHandlerRegistry.registerHandler("rmi",
                new UnopenableURLStreamHandler(1099));
    }

    /**
     * @see org.seasar.remoting.common.connector.Connector#invoke(java.lang.String,
     *      java.lang.reflect.Method, java.lang.Object[])
     */
    public Object invoke(String componentName, Method method, Object[] args)
            throws RemoteException, Exception {
        synchronized (this) {
            if (this.adaptorStub == null) {
                this.lookup();
            }
        }

        return this.adaptorStub.invoke(componentName, method.getName(), args);
    }

    /**
     * dicont@CŐݒ肳ꂽbaseURLvpeBgpāA
     * RMIWXgRMIAdaptor̃X^uNX擾܂.
     * 
     * @throws RemoteException
     *              WXgւ̖₢킹ɃX[RMI̗O
     * @throws MalformedURLException
     *              baseURLrmivgRł͂Ȃꍇ̗O
     * @throws NotBoundException
     *              RMIWXgRMIAdaptoro^̏ꍇ̗O
     */
    public void lookup() throws RemoteException, MalformedURLException,
            NotBoundException {
        URL targetURL = new URL(this.baseURL, RMIAdaptor.EXPORT_NAME);

        this.adaptorStub = (RMIAdaptor) Naming.lookup(targetURL.toString());
    }
}