/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp.webxml;

import java.io.IOException;
import java.io.InputStream;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.util.xml.MyFacesErrorHandler;
import org.apache.myfaces.util.xml.XmlUtils;
import org.apache.myfaces.webapp.webxml.WebXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class WebXmlParser {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$webapp$webxml$WebXmlParser == null ? (class$org$apache$myfaces$webapp$webxml$WebXmlParser = WebXmlParser.class$("org.apache.myfaces.webapp.webxml.WebXmlParser")) : class$org$apache$myfaces$webapp$webxml$WebXmlParser));
    private static final String WEB_XML_PATH = "/WEB-INF/web.xml";
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String WEB_APP_2_2_J2EE_SYSTEM_ID = "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd";
    private static final String WEB_APP_2_2_SYSTEM_ID = "http://java.sun.com/dtd/web-app_2_2.dtd";
    private static final String WEB_APP_2_2_RESOURCE = "javax/servlet/resources/web-app_2_2.dtd";
    private static final String WEB_APP_2_3_SYSTEM_ID = "http://java.sun.com/dtd/web-app_2_3.dtd";
    private static final String WEB_APP_2_3_RESOURCE = "javax/servlet/resources/web-app_2_3.dtd";
    private ExternalContext _context;
    private WebXml _webXml;
    static /* synthetic */ Class class$org$apache$myfaces$webapp$webxml$WebXmlParser;

    public WebXmlParser(ExternalContext context) {
        this._context = context;
    }

    public WebXml parse() {
        this._webXml = new WebXml();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setIgnoringComments(true);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new _EntityResolver());
            db.setErrorHandler(new MyFacesErrorHandler(log));
            InputSource is = this.createContextInputSource(null, WEB_XML_PATH);
            Document document = db.parse(is);
            Element webAppElem = document.getDocumentElement();
            if (webAppElem == null || !webAppElem.getNodeName().equals("web-app")) {
                throw new FacesException("No valid web-app root element found!");
            }
            this.readWebApp(webAppElem);
            return this._webXml;
        }
        catch (Exception e) {
            log.fatal((Object)"Unable to parse web.xml", (Throwable)e);
            throw new FacesException(e);
        }
    }

    private InputSource createContextInputSource(String publicId, String systemId) {
        InputStream inStream = this._context.getResourceAsStream(systemId);
        if (inStream == null) {
            return null;
        }
        InputSource is = new InputSource(inStream);
        is.setPublicId(publicId);
        is.setSystemId(systemId);
        is.setEncoding(DEFAULT_ENCODING);
        return is;
    }

    private InputSource createClassloaderInputSource(String publicId, String systemId) {
        InputStream inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(systemId);
        if (inStream == null) {
            return null;
        }
        InputSource is = new InputSource(inStream);
        is.setPublicId(publicId);
        is.setSystemId(systemId);
        is.setEncoding(DEFAULT_ENCODING);
        return is;
    }

    private void readWebApp(Element webAppElem) {
        NodeList nodeList = webAppElem.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1) {
                if (n.getNodeName().equals("servlet")) {
                    this.readServlet((Element)n);
                }
                if (!n.getNodeName().equals("servlet-mapping")) continue;
                this.readServletMapping((Element)n);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Ignored node '" + n.getNodeName() + "' of type " + n.getNodeType()));
        }
    }

    private void readServlet(Element servletElem) {
        String servletName = null;
        String servletClass = null;
        NodeList nodeList = servletElem.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1) {
                if (n.getNodeName().equals("servlet-name")) {
                    servletName = XmlUtils.getElementText((Element)n);
                    continue;
                }
                if (n.getNodeName().equals("servlet-class")) {
                    servletClass = XmlUtils.getElementText((Element)n).trim();
                    continue;
                }
                if (n.getNodeName().equals("description") || n.getNodeName().equals("load-on-startup") || !log.isWarnEnabled()) continue;
                log.warn((Object)("Ignored element '" + n.getNodeName() + "' as child of '" + servletElem.getNodeName() + "'."));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Ignored node '" + n.getNodeName() + "' of type " + n.getNodeType()));
        }
        this._webXml.addServlet(servletName, servletClass);
    }

    private void readServletMapping(Element servletMappingElem) {
        String servletName = null;
        String urlPattern = null;
        NodeList nodeList = servletMappingElem.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1) {
                if (n.getNodeName().equals("servlet-name")) {
                    servletName = XmlUtils.getElementText((Element)n);
                    continue;
                }
                if (n.getNodeName().equals("url-pattern")) {
                    urlPattern = XmlUtils.getElementText((Element)n).trim();
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Ignored element '" + n.getNodeName() + "' as child of '" + servletMappingElem.getNodeName() + "'."));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Ignored node '" + n.getNodeName() + "' of type " + n.getNodeType()));
        }
        urlPattern = urlPattern.trim();
        this._webXml.addServletMapping(servletName, urlPattern);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class _EntityResolver
    implements EntityResolver {
        private _EntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws IOException {
            if (systemId == null) {
                throw new UnsupportedOperationException("systemId must not be null");
            }
            if (systemId.equals(WebXmlParser.WEB_APP_2_2_SYSTEM_ID) || systemId.equals(WebXmlParser.WEB_APP_2_2_J2EE_SYSTEM_ID)) {
                return WebXmlParser.this.createClassloaderInputSource(publicId, WebXmlParser.WEB_APP_2_2_RESOURCE);
            }
            if (systemId.equals(WebXmlParser.WEB_APP_2_3_SYSTEM_ID)) {
                return WebXmlParser.this.createClassloaderInputSource(publicId, WebXmlParser.WEB_APP_2_3_RESOURCE);
            }
            return WebXmlParser.this.createContextInputSource(publicId, systemId);
        }
    }
}

