package org.seasar.dao.impl;

import javax.sql.DataSource;

import org.seasar.dao.CommandContext;
import org.seasar.extension.jdbc.CallableStatementFactory;
import org.seasar.extension.jdbc.impl.BasicUpdateHandler;

/**
 * @author higa
 *  
 */
public class UpdateDynamicCommand extends AbstractDynamicCommand {

	public UpdateDynamicCommand(DataSource dataSource, CallableStatementFactory callableStatementFactory) {
		super(dataSource, callableStatementFactory);
	}

	public Object execute(Object[] args) {
		CommandContext ctx = apply(args);
		BasicUpdateHandler updateHandler = new BasicUpdateHandler(
				getDataSource(), ctx.getSql(), getCallableStatementFactory());
		return new Integer(updateHandler.execute(ctx.getBindVariables(), ctx.getBindVariableTypes()));
	}

}