package examples.jsf.action.impl;

import examples.jsf.action.EmployeeEditAction;
import examples.jsf.common.Constants;
import examples.jsf.dto.EmployeeDto;
import examples.jsf.exception.EmployeeAlreadyExistRuntimeException;
import examples.jsf.logic.EmployeeLogic;

public class EmployeeEditActionImpl implements EmployeeEditAction {

	private EmployeeLogic employeeLogic;

	private Integer empno;
	
	private int processMode;
	
	private EmployeeDto employeeDto;

	public void setEmployeeLogic(EmployeeLogic employeeLogic) {
		this.employeeLogic = employeeLogic;
	}
	
	public void setEmpno(Integer empno) {
		this.empno = empno;
	}
	
	public void setProcessMode(int processMode) {
		this.processMode = processMode;
	}
	
	public int getProcessMode() {
		return processMode;
	}
	
	public EmployeeDto getEmployeeDto() {
		return employeeDto;
	}
	
	public void setEmployeeDto(EmployeeDto employeeDto) {
		this.employeeDto = employeeDto;
	}

	public String goConfirm() {
		if (processMode == Constants.CREATE_MODE && employeeLogic.existEmployee(empno)) {
			throw new EmployeeAlreadyExistRuntimeException(empno.intValue());
		}
		return "employeeConfirm";
	}
	
}